/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OutputStreamManagerTest {
    @Test
    @LoggerContextSource(value="multipleIncompatibleAppendersTest.xml")
    public void narrow(LoggerContext context) {
        ExtendedLogger logger = context.getLogger(OutputStreamManagerTest.class);
        logger.info("test");
        List statusData = StatusLogger.getLogger().getStatusData();
        StatusData data = (StatusData)statusData.get(0);
        if (data.getMessage().getFormattedMessage().contains("WindowsAnsiOutputStream")) {
            data = (StatusData)statusData.get(1);
        }
        Assertions.assertEquals((Object)Level.ERROR, (Object)data.getLevel());
        Assertions.assertEquals((Object)"Could not create plugin of type class org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender for element RollingRandomAccessFile", (Object)data.getMessage().getFormattedMessage());
        Assertions.assertEquals((Object)"org.apache.logging.log4j.core.config.ConfigurationException: Configuration has multiple incompatible Appenders pointing to the same resource 'target/multiIncompatibleAppender.log'", (Object)data.getThrowable().toString());
    }

    @Test
    public void testOutputStreamAppenderFlushClearsBufferOnException() {
        final IOException exception = new IOException();
        OutputStream throwingOutputStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                throw exception;
            }
        };
        int bufferSize = 3;
        OutputStreamManager outputStreamManager = new OutputStreamManager(throwingOutputStream, "test", null, false, 3);
        for (int i = 0; i < 2; ++i) {
            outputStreamManager.getByteBuffer().put((byte)0);
        }
        Assertions.assertEquals((int)outputStreamManager.getByteBuffer().remaining(), (int)1);
        AppenderLoggingException appenderLoggingException = (AppenderLoggingException)Assertions.assertThrows(AppenderLoggingException.class, () -> outputStreamManager.flushBuffer(outputStreamManager.getByteBuffer()));
        Assertions.assertEquals((Object)appenderLoggingException.getCause(), (Object)exception);
        Assertions.assertEquals((int)outputStreamManager.getByteBuffer().limit(), (int)outputStreamManager.getByteBuffer().capacity());
    }
}

