/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileAppenderBuilderTest {
    @Test
    public void testDefaultImmediateFlush() {
        Assertions.assertTrue((boolean)FileAppender.newBuilder().isImmediateFlush());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraints() {
        final AtomicInteger counter = new AtomicInteger();
        StatusListener listener = new StatusListener(){

            public void close() throws IOException {
            }

            public void log(StatusData data) {
                counter.incrementAndGet();
            }

            public Level getStatusLevel() {
                return Level.ERROR;
            }
        };
        try {
            StatusLogger.getLogger().registerListener(listener);
            FileAppender appender = FileAppender.newBuilder().build();
            Assertions.assertNull((Object)appender);
            Assertions.assertTrue((counter.getAndSet(0) > 0 ? 1 : 0) != 0);
            appender = FileAppender.newBuilder().withFileName("target/FileAppenderBuilderTest.log").build();
            Assertions.assertNull((Object)appender);
            Assertions.assertTrue((counter.getAndSet(0) > 0 ? 1 : 0) != 0);
            appender = ((FileAppender.Builder)FileAppender.newBuilder().setName("FILE")).build();
            Assertions.assertNull((Object)appender);
            Assertions.assertTrue((counter.getAndSet(0) > 0 ? 1 : 0) != 0);
            appender = ((FileAppender.Builder)FileAppender.newBuilder().setName("FILE")).withFileName("target/FileAppenderBuilderTest.log").build();
            Assertions.assertNotNull((Object)appender);
            Assertions.assertTrue((counter.get() == 0 ? 1 : 0) != 0);
        }
        catch (NullPointerException e) {
            Assertions.fail((Throwable)e);
        }
        finally {
            StatusLogger.getLogger().removeListener(listener);
        }
    }
}

