/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.Locale;
import org.apache.logging.log4j.EventLogger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="xml-events.xml")
@Disabled(value="TODO")
public class XmlEvents {
    @Test
    public void testEvents() {
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        TransferMessage msg = new TransferMessage();
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "123457");
        msg.put("Amount", "200.00");
        EventLogger.logEvent((StructuredDataMessage)msg);
        msg.setCompletionStatus("Transfer Complete");
        EventLogger.logEvent((StructuredDataMessage)msg);
        ThreadContext.clearMap();
    }

    @AsynchronouslyFormattable
    private static class TransferMessage
    extends StructuredDataMessage {
        private static final long serialVersionUID = -4334703653495359785L;

        public TransferMessage() {
            super("Transfer@18060", null, "Audit");
        }

        public void setCompletionStatus(String msg) {
            this.setMessageFormat(msg);
        }
    }
}

