/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.Strings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.SetSystemProperty;

@SetSystemProperty(key="log4j2.Script.enableLanguages", value="bsh, Javascript")
@LoggerContextSource(value="log4j-patternSelector.xml")
public class PatternSelectorTest {
    @Test
    public void testMarkerPatternSelector(@Named(value="List") ListAppender app) {
        Logger logger = LogManager.getLogger((String)"TestMarkerPatternSelector");
        logger.traceEntry();
        logger.info("Hello World");
        logger.traceExit();
        List<String> messages = app.getMessages();
        Assertions.assertNotNull(messages, (String)"No Messages");
        Assertions.assertEquals((int)3, (int)messages.size(), (String)("Incorrect number of messages. Expected 3, Actual " + messages.size() + ": " + messages));
        String expect = String.format("[TRACE] TestMarkerPatternSelector ====== o.a.l.l.c.PatternSelectorTest.testMarkerPatternSelector:40 Enter ======%n", new Object[0]);
        Assertions.assertEquals((Object)expect, (Object)messages.get(0));
        Assertions.assertEquals((Object)("[INFO ] TestMarkerPatternSelector Hello World" + Strings.LINE_SEPARATOR), (Object)messages.get(1));
        app.clear();
    }

    @Test
    public void testScriptPatternSelector(@Named(value="List2") ListAppender app) {
        Logger logger = LogManager.getLogger((String)"TestScriptPatternSelector");
        Logger logger2 = LogManager.getLogger((String)"NoLocation");
        logger.traceEntry();
        logger.info("Hello World");
        logger2.info("No location information");
        logger.traceExit();
        List<String> messages = app.getMessages();
        Assertions.assertNotNull(messages, (String)"No Messages");
        Assertions.assertEquals((int)4, (int)messages.size(), (String)("Incorrect number of messages. Expected 4, Actual " + messages.size() + ": " + messages));
        String expect = "[TRACE] TestScriptPatternSelector ====== o.a.l.l.c.PatternSelectorTest.testScriptPatternSelector:58 Enter ======" + Strings.LINE_SEPARATOR;
        Assertions.assertEquals((Object)expect, (Object)messages.get(0));
        expect = "[INFO ] TestScriptPatternSelector o.a.l.l.c.PatternSelectorTest.testScriptPatternSelector.59 Hello World" + Strings.LINE_SEPARATOR;
        Assertions.assertEquals((Object)expect, (Object)messages.get(1));
        Assertions.assertEquals((Object)("[INFO ] NoLocation No location information" + Strings.LINE_SEPARATOR), (Object)messages.get(2));
        app.clear();
    }

    @Test
    public void testJavaScriptPatternSelector(@Named(value="List3") ListAppender app) {
        Logger logger = LogManager.getLogger((String)"TestJavaScriptPatternSelector");
        Logger logger2 = LogManager.getLogger((String)"JavascriptNoLocation");
        logger.traceEntry();
        logger.info("Hello World");
        logger2.info("No location information");
        logger.traceExit();
        List<String> messages = app.getMessages();
        Assertions.assertNotNull(messages, (String)"No Messages");
        Assertions.assertEquals((int)4, (int)messages.size(), (String)("Incorrect number of messages. Expected 4, Actual " + messages.size() + ": " + messages));
        String expect = "[TRACE] TestJavaScriptPatternSelector ====== o.a.l.l.c.PatternSelectorTest.testJavaScriptPatternSelector:80 Enter ======" + Strings.LINE_SEPARATOR;
        Assertions.assertEquals((Object)expect, (Object)messages.get(0));
        expect = "[INFO ] TestJavaScriptPatternSelector o.a.l.l.c.PatternSelectorTest.testJavaScriptPatternSelector.81 Hello World" + Strings.LINE_SEPARATOR;
        Assertions.assertEquals((Object)expect, (Object)messages.get(1));
        Assertions.assertEquals((Object)("[INFO ] JavascriptNoLocation No location information" + Strings.LINE_SEPARATOR), (Object)messages.get(2));
        app.clear();
    }
}

