/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceAccessMode;
import org.junit.jupiter.api.parallel.ResourceLock;

@LoggerContextSource(value="log4j-collectionLogging.xml")
@Disabled(value="Work in progress")
public class CollectionLoggingTest {
    private final ListAppender app;

    public CollectionLoggingTest(@Named(value="List") ListAppender app) {
        this.app = app.clear();
    }

    @Test
    @ResourceLock(value="java.lang.System.properties", mode=ResourceAccessMode.READ)
    public void testSystemProperties(LoggerContext context) {
        Logger logger = context.getLogger(CollectionLoggingTest.class.getName());
        logger.error((Object)System.getProperties());
    }

    @Test
    @ResourceLock(value="java.lang.System.properties", mode=ResourceAccessMode.READ)
    public void testSimpleMap(LoggerContext context) {
        Logger logger = context.getLogger(CollectionLoggingTest.class.getName());
        logger.error((Object)System.getProperties());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("MyKey1", "MyValue1");
        map.put("MyKey2", "MyValue2");
        logger.error((Message)new StringMapMessage(map));
        logger.error(map);
    }

    @Test
    public void testNetworkInterfaces(LoggerContext context) throws SocketException {
        Logger logger = context.getLogger(CollectionLoggingTest.class.getName());
        logger.error(NetworkInterface.getNetworkInterfaces());
    }

    @Test
    public void testAvailableCharsets(LoggerContext context) {
        Logger logger = context.getLogger(CollectionLoggingTest.class.getName());
        logger.error(Charset.availableCharsets());
    }
}

