/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.log4j.web.Log4jWebLifeCycle;
import org.apache.logging.log4j.web.Log4jWebSupport;
import org.apache.logging.log4j.web.WebLoggerContextUtils;

public class Log4jShutdownOnContextDestroyedListener
implements ServletContextListener {
    private static final int DEFAULT_STOP_TIMEOUT = 30;
    private static final TimeUnit DEFAULT_STOP_TIMEOUT_TIMEUNIT = TimeUnit.SECONDS;
    private static final String KEY_STOP_TIMEOUT = "log4j.stop.timeout";
    private static final String KEY_STOP_TIMEOUT_TIMEUNIT = "log4j.stop.timeout.timeunit";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private ServletContext servletContext;
    private Log4jWebLifeCycle initializer;

    public void contextInitialized(ServletContextEvent event) {
        LOGGER.debug(Log4jShutdownOnContextDestroyedListener.class.getSimpleName() + " ensuring that Log4j started up properly.");
        this.servletContext = event.getServletContext();
        if (null == this.servletContext.getAttribute(Log4jWebSupport.SUPPORT_ATTRIBUTE)) {
            throw new IllegalStateException("Context did not contain required Log4jWebLifeCycle in the " + Log4jWebSupport.SUPPORT_ATTRIBUTE + " attribute.");
        }
        this.initializer = WebLoggerContextUtils.getWebLifeCycle(this.servletContext);
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.servletContext == null || this.initializer == null) {
            LOGGER.warn("Context destroyed before it was initialized.");
            return;
        }
        LOGGER.debug(Log4jShutdownOnContextDestroyedListener.class.getSimpleName() + " ensuring that Log4j shuts down properly.");
        this.initializer.clearLoggerContext();
        if (this.initializer instanceof LifeCycle2) {
            String stopTimeoutStr = this.servletContext.getInitParameter(KEY_STOP_TIMEOUT);
            long stopTimeout = Strings.isEmpty((CharSequence)stopTimeoutStr) ? 30L : Long.parseLong(stopTimeoutStr);
            String timeoutTimeUnitStr = this.servletContext.getInitParameter(KEY_STOP_TIMEOUT_TIMEUNIT);
            TimeUnit timeoutTimeUnit = Strings.isEmpty((CharSequence)timeoutTimeUnitStr) ? DEFAULT_STOP_TIMEOUT_TIMEUNIT : TimeUnit.valueOf(timeoutTimeUnitStr.toUpperCase(Locale.ROOT));
            ((LifeCycle2)this.initializer).stop(stopTimeout, timeoutTimeUnit);
        } else {
            this.initializer.stop();
        }
    }
}

