/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.core.util.WatchManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS})
@EnabledIfSystemProperty(named="WatchManagerTest.forceRun", matches="true")
public class WatchManagerTest {
    private final String testFile = "target/testWatchFile";
    private final String originalFile = "target/test-classes/log4j-test1.xml";
    private final String newFile = "target/test-classes/log4j-test1.yaml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatchManager() throws Exception {
        ConfigurationScheduler scheduler = new ConfigurationScheduler();
        scheduler.incrementScheduledItems();
        WatchManager watchManager = new WatchManager(scheduler);
        watchManager.setIntervalSeconds(1);
        scheduler.start();
        watchManager.start();
        try {
            File sourceFile = new File("target/test-classes/log4j-test1.xml");
            Path source = Paths.get(sourceFile.toURI());
            try (FileOutputStream targetStream = new FileOutputStream("target/testWatchFile");){
                Files.copy(source, targetStream);
            }
            File updateFile = new File("target/test-classes/log4j-test1.yaml");
            File targetFile = new File("target/testWatchFile");
            LinkedBlockingQueue<File> queue = new LinkedBlockingQueue<File>();
            watchManager.watchFile(targetFile, (FileWatcher)new TestWatcher(queue));
            Thread.sleep(1000L);
            source = Paths.get(updateFile.toURI());
            Files.copy(source, Paths.get(targetFile.toURI()), StandardCopyOption.REPLACE_EXISTING);
            Thread.sleep(1000L);
            File f = (File)queue.poll(1L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)f, (String)"File change not detected");
        }
        finally {
            watchManager.stop();
            scheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatchManagerReset() throws Exception {
        ConfigurationScheduler scheduler = new ConfigurationScheduler();
        scheduler.incrementScheduledItems();
        WatchManager watchManager = new WatchManager(scheduler);
        watchManager.setIntervalSeconds(1);
        scheduler.start();
        watchManager.start();
        try {
            File sourceFile = new File("target/test-classes/log4j-test1.xml");
            Path source = Paths.get(sourceFile.toURI());
            try (FileOutputStream targetStream = new FileOutputStream("target/testWatchFile");){
                Files.copy(source, targetStream);
            }
            File updateFile = new File("target/test-classes/log4j-test1.yaml");
            File targetFile = new File("target/testWatchFile");
            LinkedBlockingQueue<File> queue = new LinkedBlockingQueue<File>();
            watchManager.watchFile(targetFile, (FileWatcher)new TestWatcher(queue));
            watchManager.stop();
            Thread.sleep(1000L);
            source = Paths.get(updateFile.toURI());
            Files.copy(source, Paths.get(targetFile.toURI()), StandardCopyOption.REPLACE_EXISTING);
            watchManager.reset();
            watchManager.start();
            Thread.sleep(1000L);
            File f = (File)queue.poll(1L, TimeUnit.SECONDS);
            Assertions.assertNull((Object)f, (String)"File change detected");
        }
        finally {
            watchManager.stop();
            scheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatchManagerResetFile() throws Exception {
        ConfigurationScheduler scheduler = new ConfigurationScheduler();
        scheduler.incrementScheduledItems();
        WatchManager watchManager = new WatchManager(scheduler);
        watchManager.setIntervalSeconds(1);
        scheduler.start();
        watchManager.start();
        try {
            File sourceFile = new File("target/test-classes/log4j-test1.xml");
            Path source = Paths.get(sourceFile.toURI());
            try (FileOutputStream targetStream = new FileOutputStream("target/testWatchFile");){
                Files.copy(source, targetStream);
            }
            File updateFile = new File("target/test-classes/log4j-test1.yaml");
            File targetFile = new File("target/testWatchFile");
            LinkedBlockingQueue<File> queue = new LinkedBlockingQueue<File>();
            watchManager.watchFile(targetFile, (FileWatcher)new TestWatcher(queue));
            watchManager.stop();
            Thread.sleep(1000L);
            source = Paths.get(updateFile.toURI());
            Files.copy(source, Paths.get(targetFile.toURI()), StandardCopyOption.REPLACE_EXISTING);
            watchManager.reset(targetFile);
            watchManager.start();
            Thread.sleep(1000L);
            File f = (File)queue.poll(1L, TimeUnit.SECONDS);
            Assertions.assertNull((Object)f, (String)"File change detected");
        }
        finally {
            watchManager.stop();
            scheduler.stop();
        }
    }

    private static class TestWatcher
    implements FileWatcher {
        private final Queue<File> queue;

        public TestWatcher(Queue<File> queue) {
            this.queue = queue;
        }

        public void fileModified(File file) {
            System.out.println(file.toString() + " was modified");
            this.queue.add(file);
        }
    }
}

