/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.status.StatusLogger;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SocketAppenderReconnectTest {
    private static final long DEFAULT_POLL_MILLIS = 1000L;
    private static final int EPHEMERAL_PORT = 0;
    private static final Logger LOGGER = StatusLogger.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void repeating_reconnect_failures_should_be_propagated() throws Exception {
        try (LineReadingTcpServer server = new LineReadingTcpServer();){
            server.start("Main", 0);
            int port = server.serverSocket.getLocalPort();
            LoggerContext loggerContext = SocketAppenderReconnectTest.initContext(port);
            try {
                SocketAppenderReconnectTest.verifyLoggingSuccess(server);
                server.close();
                SocketAppenderReconnectTest.verifyLoggingFailure();
                server.start("Main", port);
                SocketAppenderReconnectTest.verifyLoggingSuccess(server);
            }
            finally {
                Configurator.shutdown((LoggerContext)loggerContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void reconnect_should_fallback_when_there_are_multiple_resolved_hosts() throws Exception {
        try (LineReadingTcpServer primaryServer = new LineReadingTcpServer();
             LineReadingTcpServer secondaryServer = new LineReadingTcpServer();){
            primaryServer.start("Primary", 0);
            secondaryServer.start("Secondary", 0);
            FixedHostResolver hostResolver = FixedHostResolver.ofServers(new LineReadingTcpServer[]{primaryServer, secondaryServer});
            TcpSocketManager.setHostResolver((TcpSocketManager.HostResolver)hostResolver);
            try {
                LoggerContext loggerContext = SocketAppenderReconnectTest.initContext(0);
                try {
                    SocketAppenderReconnectTest.verifyLoggingSuccess(primaryServer);
                    primaryServer.close();
                    SocketAppenderReconnectTest.verifyLoggingSuccess(secondaryServer);
                }
                finally {
                    Configurator.shutdown((LoggerContext)loggerContext);
                }
            }
            finally {
                TcpSocketManager.setHostResolver((TcpSocketManager.HostResolver)new TcpSocketManager.HostResolver());
            }
        }
    }

    private static LoggerContext initContext(int port) {
        ConfigurationBuilder configBuilder = ConfigurationBuilderFactory.newConfigurationBuilder().setStatusLevel(Level.ERROR).setConfigurationName(SocketAppenderReconnectTest.class.getSimpleName());
        String appenderName = "Socket";
        Configuration config = configBuilder.add(((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)configBuilder.newAppender("Socket", "SOCKET").addAttribute("host", "localhost")).addAttribute("port", String.valueOf(port))).addAttribute("protocol", (Enum)Protocol.TCP)).addAttribute("ignoreExceptions", false)).addAttribute("reconnectionDelayMillis", 10)).addAttribute("immediateFlush", true)).add((LayoutComponentBuilder)configBuilder.newLayout("PatternLayout").addAttribute("pattern", "%m%n"))).add(configBuilder.newLogger("org.apache.logging.log4j", Level.DEBUG)).add((RootLoggerComponentBuilder)configBuilder.newRootLogger(Level.ERROR).add(configBuilder.newAppenderRef("Socket"))).build(false);
        return Configurator.initialize((Configuration)config);
    }

    private static void verifyLoggingSuccess(LineReadingTcpServer server) throws Exception {
        int messageCount = 100;
        Assertions.assertTrue((boolean)true, (String)"was expecting messageCount to be bigger than 1 due to LOG4J2-2829, found: 100");
        List<String> expectedMessages = IntStream.range(0, 100).mapToObj(messageIndex -> String.format("m%02d", messageIndex)).collect(Collectors.toList());
        Logger logger = LogManager.getLogger();
        for (int messageIndex2 = 0; messageIndex2 < expectedMessages.size(); ++messageIndex2) {
            String message = (String)expectedMessages.get(messageIndex2);
            if (messageIndex2 == 0) {
                SocketAppenderReconnectTest.awaitUntilSucceeds(() -> logger.info(message));
                continue;
            }
            logger.info(message);
        }
        expectedMessages.forEach(arg_0 -> ((Logger)logger).info(arg_0));
        List actualMessages = server.pollLines(100);
        Assertions.assertEquals(expectedMessages, (Object)actualMessages);
    }

    private static void awaitUntilSucceeds(Runnable runnable) {
        long pollIntervalMillis = 1000L;
        long timeoutSeconds = 120L;
        Awaitility.await().pollInterval(1000L, TimeUnit.MILLISECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            runnable.run();
            return true;
        });
    }

    private static void verifyLoggingFailure() {
        Logger logger = LogManager.getLogger();
        int retryCount = 3;
        Assertions.assertTrue((retryCount > 1 ? 1 : 0) != 0, (String)("was expecting retryCount to be bigger than 1 due to LOG4J2-2829, found: " + retryCount));
        for (int i = 0; i < retryCount; ++i) {
            try {
                logger.info("should fail #" + i);
                Assertions.fail((String)("should have failed #" + i));
                continue;
            }
            catch (AppenderLoggingException appenderLoggingException) {
                // empty catch block
            }
        }
    }

    private static final class FixedHostResolver
    extends TcpSocketManager.HostResolver {
        private final List<InetSocketAddress> addresses;

        private FixedHostResolver(List<InetSocketAddress> addresses) {
            this.addresses = addresses;
        }

        private static FixedHostResolver ofServers(LineReadingTcpServer ... servers) {
            List<InetSocketAddress> addresses = Arrays.stream(servers).map(server -> (InetSocketAddress)((LineReadingTcpServer)server).serverSocket.getLocalSocketAddress()).collect(Collectors.toList());
            return new FixedHostResolver(addresses);
        }

        public List<InetSocketAddress> resolveHost(String ignoredHost, int ignoredPort) {
            return this.addresses;
        }
    }

    private static final class LineReadingTcpServer
    implements AutoCloseable {
        private static final int UNBOUND_PORT = -1;
        private volatile boolean running;
        private ServerSocket serverSocket;
        private Socket clientSocket;
        private Thread readerThread;
        private final BlockingQueue<String> lines = new LinkedBlockingQueue<String>();

        private LineReadingTcpServer() {
        }

        private synchronized void start(String name, int port) throws IOException {
            if (!this.running) {
                this.running = true;
                this.serverSocket = this.createServerSocket(port);
                this.readerThread = this.createReaderThread(name);
                if (this.serverSocket.getLocalPort() == -1 || !this.serverSocket.isBound()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                }
                Assertions.assertNotEquals((int)-1, (int)this.serverSocket.getLocalPort(), () -> String.format("Server socket is not bound to port %s (0 = ephemeral). This can only happen if a machine runs out of ports.", port));
            }
        }

        private ServerSocket createServerSocket(int port) throws IOException {
            ServerSocket serverSocket = new ServerSocket(port);
            serverSocket.setReuseAddress(true);
            serverSocket.setSoTimeout(0);
            return serverSocket;
        }

        private Thread createReaderThread(String name) {
            String threadName = "LineReadingTcpSocketServerReader-" + name;
            Thread thread = new Thread(this::acceptClients, threadName);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((ignored, error) -> LOGGER.error("uncaught reader thread exception", error));
            thread.start();
            return thread;
        }

        private void acceptClients() {
            try {
                while (this.running) {
                    this.acceptClient();
                }
            }
            catch (Exception error) {
                LOGGER.error("failed accepting client connections", (Throwable)error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acceptClient() throws Exception {
            AutoCloseable clientInputStream;
            Socket clientSocket;
            try {
                clientSocket = this.serverSocket.accept();
            }
            catch (SocketException ignored) {
                return;
            }
            clientSocket.setSoLinger(true, 0);
            LineReadingTcpServer ignored = this;
            synchronized (ignored) {
                if (this.running) {
                    this.clientSocket = clientSocket;
                }
            }
            try {
                clientInputStream = clientSocket.getInputStream();
                Throwable throwable = null;
                try (InputStreamReader clientReader = new InputStreamReader((InputStream)clientInputStream, StandardCharsets.UTF_8);
                     BufferedReader clientBufferedReader = new BufferedReader(clientReader);){
                    while (this.running) {
                        String line = clientBufferedReader.readLine();
                        if (line == null) {
                            break;
                        }
                        this.lines.put(line);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (clientInputStream != null) {
                        if (throwable != null) {
                            try {
                                clientInputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            clientInputStream.close();
                        }
                    }
                }
            }
            catch (SocketException error) {
            }
            finally {
                try {
                    clientInputStream = this;
                    synchronized (clientInputStream) {
                        if (!clientSocket.isClosed()) {
                            clientSocket.shutdownOutput();
                            clientSocket.close();
                        }
                        this.clientSocket = null;
                    }
                }
                catch (Exception error) {
                    LOGGER.error("failed closing client socket", (Throwable)error);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws Exception {
            Thread stoppedReaderThread = null;
            LineReadingTcpServer lineReadingTcpServer = this;
            synchronized (lineReadingTcpServer) {
                if (this.running) {
                    this.running = false;
                    if (this.clientSocket != null && !this.clientSocket.isClosed()) {
                        this.clientSocket.close();
                    }
                    this.serverSocket.close();
                    stoppedReaderThread = this.readerThread;
                    this.clientSocket = null;
                    this.serverSocket = null;
                    this.readerThread = null;
                }
            }
            if (stoppedReaderThread != null) {
                stoppedReaderThread.join();
            }
        }

        private List<String> pollLines(int count) throws InterruptedException, TimeoutException {
            ArrayList<String> polledLines = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                String polledLine = this.pollLine();
                polledLines.add(polledLine);
            }
            return polledLines;
        }

        private String pollLine() throws InterruptedException, TimeoutException {
            String line = this.lines.poll(2L, TimeUnit.SECONDS);
            if (line == null) {
                throw new TimeoutException();
            }
            return line;
        }
    }
}

