/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.junit.JndiRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class InterpolatorTest {
    private static final String TESTKEY = "TestKey";
    private static final String TESTKEY2 = "TestKey2";
    private static final String TESTVAL = "TestValue";
    private static final String TEST_CONTEXT_RESOURCE_NAME = "logging/context-name";
    private static final String TEST_CONTEXT_NAME = "app-1";
    @ClassRule
    public static final RuleChain RULES = RuleChain.outerRule((TestRule)new ExternalResource(){

        protected void before() throws Throwable {
            System.setProperty(InterpolatorTest.TESTKEY, InterpolatorTest.TESTVAL);
            System.setProperty(InterpolatorTest.TESTKEY2, InterpolatorTest.TESTVAL);
            System.setProperty("log4j2.enableJndiLookup", "true");
        }

        protected void after() {
            System.clearProperty(InterpolatorTest.TESTKEY);
            System.clearProperty(InterpolatorTest.TESTKEY2);
            System.clearProperty("log4j2.enableJndiLookup");
        }
    }).around((TestRule)new JndiRule("java:comp/env/logging/context-name", "app-1"));

    @Test
    public void testGetDefaultLookup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, TESTVAL);
        MapLookup defaultLookup = new MapLookup(map);
        Interpolator interpolator = new Interpolator((StrLookup)defaultLookup);
        Assertions.assertEquals((Object)defaultLookup.getMap(), (Object)((MapLookup)interpolator.getDefaultLookup()).getMap());
        Assert.assertSame((Object)defaultLookup, (Object)interpolator.getDefaultLookup());
    }

    @Test
    public void testLookup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, TESTVAL);
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        ThreadContext.put((String)TESTKEY, (String)TESTVAL);
        String value = lookup.lookup(TESTKEY);
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("ctx:TestKey");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("sys:TestKey");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("SYS:TestKey2");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("BadKey");
        Assertions.assertNull((Object)value);
        ThreadContext.clearMap();
        value = lookup.lookup("ctx:TestKey");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("jndi:logging/context-name");
        Assertions.assertEquals((Object)TEST_CONTEXT_NAME, (Object)value);
    }

    private void assertLookupNotEmpty(StrLookup lookup, String key) {
        String value = lookup.lookup(key);
        Assert.assertNotNull((Object)value);
        Assert.assertFalse((boolean)value.isEmpty());
        System.out.println(key + " = " + value);
    }

    @Test
    public void testLookupWithDefaultInterpolator() {
        Interpolator lookup = new Interpolator();
        String value = lookup.lookup("sys:TestKey");
        Assertions.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("env:PATH");
        Assert.assertNotNull((Object)value);
        value = lookup.lookup("jndi:logging/context-name");
        Assertions.assertEquals((Object)TEST_CONTEXT_NAME, (Object)value);
        value = lookup.lookup("date:yyyy-MM-dd");
        Assert.assertNotNull((String)"No Date", (Object)value);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String today = format.format(new Date());
        Assertions.assertEquals((Object)value, (Object)today);
        this.assertLookupNotEmpty((StrLookup)lookup, "java:version");
        this.assertLookupNotEmpty((StrLookup)lookup, "java:runtime");
        this.assertLookupNotEmpty((StrLookup)lookup, "java:vm");
        this.assertLookupNotEmpty((StrLookup)lookup, "java:os");
        this.assertLookupNotEmpty((StrLookup)lookup, "java:locale");
        this.assertLookupNotEmpty((StrLookup)lookup, "java:hw");
    }

    @Test
    public void testInterpolatorMapMessageWithNoPrefix() {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        configProperties.put("key", "configProperties");
        Interpolator interpolator = new Interpolator(configProperties);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "mapMessage");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn(Logger.class.getName()).setLevel(Level.INFO).setMessage((Message)new StringMapMessage(map)).build();
        Assertions.assertEquals((Object)"configProperties", (Object)interpolator.lookup((LogEvent)event, "key"));
    }

    @Test
    public void testInterpolatorMapMessageWithNoPrefixConfigDoesntMatch() {
        Interpolator interpolator = new Interpolator(Collections.emptyMap());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "mapMessage");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn(Logger.class.getName()).setLevel(Level.INFO).setMessage((Message)new StringMapMessage(map)).build();
        Assertions.assertNull((Object)interpolator.lookup((LogEvent)event, "key"), (String)"Values without a map prefix should not match MapMessages");
    }

    @Test
    public void testInterpolatorMapMessageWithMapPrefix() {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        configProperties.put("key", "configProperties");
        Interpolator interpolator = new Interpolator(configProperties);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "mapMessage");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn(Logger.class.getName()).setLevel(Level.INFO).setMessage((Message)new StringMapMessage(map)).build();
        Assertions.assertEquals((Object)"mapMessage", (Object)interpolator.lookup((LogEvent)event, "map:key"));
    }
}

