/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.security.Key;
import java.security.Permission;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.convert.Base64Converter;
import org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.impl.ThrowableProxyHelper;
import org.apache.logging.log4j.core.jackson.Log4jJsonObjectMapper;
import org.apache.logging.log4j.core.jackson.Log4jXmlObjectMapper;
import org.apache.logging.log4j.core.pattern.PlainTextRenderer;
import org.apache.logging.log4j.core.pattern.TextRenderer;
import org.apache.logging.log4j.util.Constants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThrowableProxyTest {
    private ThrowableProxy deserialize(byte[] binary) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inArr = new ByteArrayInputStream(binary);
        ObjectInputStream in = new ObjectInputStream(inArr);
        return (ThrowableProxy)in.readObject();
    }

    private byte[] serialize(ThrowableProxy proxy) throws IOException {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(arr);
        out.writeObject(proxy);
        return arr.toByteArray();
    }

    private boolean allLinesContain(String text, String containedText) {
        String[] lines;
        for (String line : lines = text.split("\n")) {
            if (line.isEmpty() || line.contains(containedText)) continue;
            return false;
        }
        return true;
    }

    private boolean lastLineContains(String text, String containedText) {
        String[] lines = text.split("\n");
        String lastLine = lines[lines.length - 1];
        return lastLine.contains(containedText);
    }

    private void testIoContainer(ObjectMapper objectMapper) throws IOException {
        Fixture expected = new Fixture();
        String s = objectMapper.writeValueAsString((Object)expected);
        Fixture actual = (Fixture)objectMapper.readValue(s, Fixture.class);
        Assertions.assertEquals((Object)expected.proxy.getName(), (Object)actual.proxy.getName());
        Assertions.assertEquals((Object)expected.proxy.getMessage(), (Object)actual.proxy.getMessage());
        Assertions.assertEquals((Object)expected.proxy.getLocalizedMessage(), (Object)actual.proxy.getLocalizedMessage());
        Assertions.assertEquals((int)expected.proxy.getCommonElementCount(), (int)actual.proxy.getCommonElementCount());
        Assertions.assertArrayEquals((Object[])expected.proxy.getExtendedStackTrace(), (Object[])actual.proxy.getExtendedStackTrace());
        Assertions.assertEquals((Object)expected.proxy, (Object)actual.proxy);
    }

    @Test
    public void testIoContainerAsJson() throws IOException {
        this.testIoContainer((ObjectMapper)new Log4jJsonObjectMapper());
    }

    @Test
    public void testIoContainerAsXml() throws IOException {
        this.testIoContainer((ObjectMapper)new Log4jXmlObjectMapper());
    }

    @Test
    public void testLogStackTraceWithClassThatCannotInitialize() {
        Error e = (Error)Assertions.assertThrows(Error.class, AlwaysThrowsError::new);
        Logger logger = LogManager.getLogger(this.getClass());
        Assertions.assertDoesNotThrow(() -> {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error((Object)e);
        });
    }

    @Test
    public void testLogStackTraceWithClassThatWillCauseSecurityException() throws IOException {
        SecurityManager sm = System.getSecurityManager();
        try {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                    if (perm instanceof RuntimePermission && "accessClassInPackage.sun.nio.ch".equals(perm.getName())) {
                        throw new SecurityException(perm.toString());
                    }
                }
            });
            BindException e = (BindException)Assertions.assertThrows(BindException.class, () -> {
                ServerSocketChannel.open().socket().bind(new InetSocketAddress("localhost", 9300));
                ServerSocketChannel.open().socket().bind(new InetSocketAddress("localhost", 9300));
            });
            Assertions.assertDoesNotThrow(() -> new ThrowableProxy((Throwable)e));
        }
        finally {
            System.setSecurityManager(sm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogStackTraceWithClassLoaderThatWithCauseSecurityException() throws Exception {
        SecurityManager sm = System.getSecurityManager();
        try {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                    if (perm instanceof RuntimePermission && "getClassLoader".equals(perm.getName())) {
                        throw new SecurityException(perm.toString());
                    }
                }
            });
            String algorithm = "AES/CBC/PKCS5Padding";
            Cipher ec = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] bytes = new byte[16];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(bytes);
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(128);
            IvParameterSpec algorithmParameterSpec = new IvParameterSpec(bytes);
            ec.init(1, (Key)generator.generateKey(), algorithmParameterSpec, secureRandom);
            byte[] raw = Constants.EMPTY_BYTE_ARRAY;
            byte[] encrypted = ec.doFinal(raw);
            Cipher dc = Cipher.getInstance("AES/CBC/PKCS5Padding");
            dc.init(2, (Key)generator.generateKey(), algorithmParameterSpec, secureRandom);
            BadPaddingException e = (BadPaddingException)Assertions.assertThrows(BadPaddingException.class, () -> dc.doFinal(encrypted));
            Assertions.assertDoesNotThrow(() -> new ThrowableProxy((Throwable)e));
        }
        finally {
            System.setSecurityManager(sm);
        }
    }

    @Test
    public void testSerialization() throws Exception {
        IllegalArgumentException throwable = new IllegalArgumentException("This is a test");
        ThrowableProxy proxy = new ThrowableProxy((Throwable)throwable);
        byte[] binary = this.serialize(proxy);
        ThrowableProxy proxy2 = this.deserialize(binary);
        Assertions.assertEquals((Object)proxy.getName(), (Object)proxy2.getName());
        Assertions.assertEquals((Object)proxy.getMessage(), (Object)proxy2.getMessage());
        Assertions.assertEquals((Object)proxy.getCauseProxy(), (Object)proxy2.getCauseProxy());
        Assertions.assertArrayEquals((Object[])proxy.getExtendedStackTrace(), (Object[])proxy2.getExtendedStackTrace());
    }

    @Test
    public void testSerialization_getExtendedStackTraceAsString() throws Exception {
        IllegalArgumentException throwable = new IllegalArgumentException("This is a test");
        ThrowableProxy proxy = new ThrowableProxy((Throwable)throwable);
        byte[] binary = this.serialize(proxy);
        ThrowableProxy proxy2 = this.deserialize(binary);
        Assertions.assertEquals((Object)proxy.getExtendedStackTraceAsString(""), (Object)proxy2.getExtendedStackTraceAsString(""));
    }

    @Test
    public void testSerialization_getExtendedStackTraceAsStringWithNestedThrowableDepth1() throws Exception {
        RuntimeException throwable = new RuntimeException(new IllegalArgumentException("This is a test"));
        this.testSerialization_getExtendedStackTraceAsStringWithNestedThrowable(throwable);
    }

    @Test
    public void testSerialization_getExtendedStackTraceAsStringWithNestedThrowableDepth2() throws Exception {
        RuntimeException throwable = new RuntimeException(new IllegalArgumentException("This is a test", new IOException("level 2")));
        this.testSerialization_getExtendedStackTraceAsStringWithNestedThrowable(throwable);
    }

    @Test
    public void testSerialization_getExtendedStackTraceAsStringWithNestedThrowableDepth3() throws Exception {
        RuntimeException throwable = new RuntimeException(new IllegalArgumentException("level 1", new IOException("level 2", new IllegalStateException("level 3"))));
        this.testSerialization_getExtendedStackTraceAsStringWithNestedThrowable(throwable);
    }

    private void testSerialization_getExtendedStackTraceAsStringWithNestedThrowable(Throwable throwable) throws Exception {
        ThrowableProxy proxy = new ThrowableProxy(throwable);
        byte[] binary = this.serialize(proxy);
        ThrowableProxy proxy2 = this.deserialize(binary);
        Assertions.assertEquals((Object)proxy.getExtendedStackTraceAsString(""), (Object)proxy2.getExtendedStackTraceAsString(""));
    }

    @Test
    public void testSerializationWithUnknownThrowable() throws Exception {
        String msg = "OMG I've been deleted!";
        String base64 = "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";
        byte[] binaryDecoded = Base64Converter.parseBase64Binary((String)"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");
        ThrowableProxy proxy2 = this.deserialize(binaryDecoded);
        Assertions.assertEquals((Object)(this.getClass().getName() + "$DeletedException"), (Object)proxy2.getName());
        Assertions.assertEquals((Object)"OMG I've been deleted!", (Object)proxy2.getMessage());
    }

    @Test
    public void testSeparator_getExtendedStackTraceAsString() throws Exception {
        IllegalArgumentException throwable = new IllegalArgumentException("This is a test");
        ThrowableProxy proxy = new ThrowableProxy((Throwable)throwable);
        String separator = " | ";
        String extendedStackTraceAsString = proxy.getExtendedStackTraceAsString(null, (TextRenderer)PlainTextRenderer.getInstance(), " | ", "");
        Assertions.assertTrue((boolean)this.allLinesContain(extendedStackTraceAsString, " | "), (String)extendedStackTraceAsString);
    }

    @Test
    public void testSuffix_getExtendedStackTraceAsString() throws Exception {
        IllegalArgumentException throwable = new IllegalArgumentException("This is a test");
        ThrowableProxy proxy = new ThrowableProxy((Throwable)throwable);
        String suffix = "some suffix";
        String extendedStackTraceAsString = proxy.getExtendedStackTraceAsString("some suffix");
        Assertions.assertTrue((boolean)this.lastLineContains(extendedStackTraceAsString, "some suffix"), (String)extendedStackTraceAsString);
    }

    @Test
    public void testSuffix_getExtendedStackTraceAsStringWithCausedThrowable() throws Exception {
        RuntimeException throwable = new RuntimeException(new IllegalArgumentException("This is a test"));
        ThrowableProxy proxy = new ThrowableProxy((Throwable)throwable);
        String suffix = "some suffix";
        Assertions.assertTrue((boolean)this.allLinesContain(proxy.getExtendedStackTraceAsString("some suffix"), "some suffix"));
    }

    @Test
    public void testSuffix_getExtendedStackTraceAsStringWithSuppressedThrowable() throws Exception {
        IllegalArgumentException cause = new IllegalArgumentException("This is a test");
        RuntimeException throwable = new RuntimeException(cause);
        throwable.addSuppressed(new IOException("This is a test"));
        ThrowableProxy proxy = new ThrowableProxy((Throwable)throwable);
        String suffix = "some suffix";
        Assertions.assertTrue((boolean)this.allLinesContain(proxy.getExtendedStackTraceAsString("some suffix"), "some suffix"));
    }

    @Test
    public void testSuffix_getCauseStackTraceAsString() throws Exception {
        IllegalArgumentException throwable = new IllegalArgumentException("This is a test");
        ThrowableProxy proxy = new ThrowableProxy((Throwable)throwable);
        String suffix = "some suffix";
        Assertions.assertTrue((boolean)this.allLinesContain(proxy.getCauseStackTraceAsString("some suffix"), "some suffix"));
    }

    @Test
    public void testSuffix_getCauseStackTraceAsStringWithCausedThrowable() throws Exception {
        RuntimeException throwable = new RuntimeException(new IllegalArgumentException("This is a test"));
        ThrowableProxy proxy = new ThrowableProxy((Throwable)throwable);
        String suffix = "some suffix";
        Assertions.assertTrue((boolean)this.allLinesContain(proxy.getCauseStackTraceAsString("some suffix"), "some suffix"));
    }

    @Test
    public void testSuffix_getCauseStackTraceAsStringWithSuppressedThrowable() throws Exception {
        IllegalArgumentException cause = new IllegalArgumentException("This is a test");
        RuntimeException throwable = new RuntimeException(cause);
        throwable.addSuppressed(new IOException("This is a test"));
        ThrowableProxy proxy = new ThrowableProxy((Throwable)throwable);
        String suffix = "some suffix";
        Assertions.assertTrue((boolean)this.allLinesContain(proxy.getCauseStackTraceAsString("some suffix"), "some suffix"));
    }

    @Test
    public void testStack() {
        HashMap map = new HashMap();
        ArrayDeque stack = new ArrayDeque();
        IllegalStateException throwable = new IllegalStateException("This is a test");
        ThrowableProxy proxy = new ThrowableProxy((Throwable)throwable);
        ExtendedStackTraceElement[] callerPackageData = ThrowableProxyHelper.toExtendedStackTrace((ThrowableProxy)proxy, stack, map, null, (StackTraceElement[])throwable.getStackTrace());
        Assertions.assertNotNull((Object)callerPackageData, (String)"No package data returned");
    }

    @Test
    public void testStackWithUnloadableClass() throws Exception {
        ArrayDeque stack = new ArrayDeque();
        HashMap map = new HashMap();
        String runtimeExceptionThrownAtUnloadableClass_base64 = "rO0ABXNyABpqYXZhLmxhbmcuUnVudGltZUV4Y2VwdGlvbp5fBkcKNIPlAgAAeHIAE2phdmEubGFuZy5FeGNlcHRpb27Q/R8+GjscxAIAAHhyABNqYXZhLmxhbmcuVGhyb3dhYmxl1cY1Jzl3uMsDAANMAAVjYXVzZXQAFUxqYXZhL2xhbmcvVGhyb3dhYmxlO0wADWRldGFpbE1lc3NhZ2V0ABJMamF2YS9sYW5nL1N0cmluZztbAApzdGFja1RyYWNldAAeW0xqYXZhL2xhbmcvU3RhY2tUcmFjZUVsZW1lbnQ7eHBxAH4ABnB1cgAeW0xqYXZhLmxhbmcuU3RhY2tUcmFjZUVsZW1lbnQ7AkYqPDz9IjkCAAB4cAAAAAFzcgAbamF2YS5sYW5nLlN0YWNrVHJhY2VFbGVtZW50YQnFmiY23YUCAARJAApsaW5lTnVtYmVyTAAOZGVjbGFyaW5nQ2xhc3NxAH4ABEwACGZpbGVOYW1lcQB+AARMAAptZXRob2ROYW1lcQB+AAR4cAAAAAZ0ADxvcmcuYXBhY2hlLmxvZ2dpbmcubG9nNGouY29yZS5pbXBsLkZvcmNlTm9EZWZDbGFzc0ZvdW5kRXJyb3J0AB5Gb3JjZU5vRGVmQ2xhc3NGb3VuZEVycm9yLmphdmF0AARtYWlueA==";
        byte[] binaryDecoded = Base64Converter.parseBase64Binary((String)"rO0ABXNyABpqYXZhLmxhbmcuUnVudGltZUV4Y2VwdGlvbp5fBkcKNIPlAgAAeHIAE2phdmEubGFuZy5FeGNlcHRpb27Q/R8+GjscxAIAAHhyABNqYXZhLmxhbmcuVGhyb3dhYmxl1cY1Jzl3uMsDAANMAAVjYXVzZXQAFUxqYXZhL2xhbmcvVGhyb3dhYmxlO0wADWRldGFpbE1lc3NhZ2V0ABJMamF2YS9sYW5nL1N0cmluZztbAApzdGFja1RyYWNldAAeW0xqYXZhL2xhbmcvU3RhY2tUcmFjZUVsZW1lbnQ7eHBxAH4ABnB1cgAeW0xqYXZhLmxhbmcuU3RhY2tUcmFjZUVsZW1lbnQ7AkYqPDz9IjkCAAB4cAAAAAFzcgAbamF2YS5sYW5nLlN0YWNrVHJhY2VFbGVtZW50YQnFmiY23YUCAARJAApsaW5lTnVtYmVyTAAOZGVjbGFyaW5nQ2xhc3NxAH4ABEwACGZpbGVOYW1lcQB+AARMAAptZXRob2ROYW1lcQB+AAR4cAAAAAZ0ADxvcmcuYXBhY2hlLmxvZ2dpbmcubG9nNGouY29yZS5pbXBsLkZvcmNlTm9EZWZDbGFzc0ZvdW5kRXJyb3J0AB5Gb3JjZU5vRGVmQ2xhc3NGb3VuZEVycm9yLmphdmF0AARtYWlueA==");
        ByteArrayInputStream inArr = new ByteArrayInputStream(binaryDecoded);
        ObjectInputStream in = new ObjectInputStream(inArr);
        Throwable throwable = (Throwable)in.readObject();
        ThrowableProxy subject = new ThrowableProxy(throwable);
        ThrowableProxyHelper.toExtendedStackTrace((ThrowableProxy)subject, stack, map, null, (StackTraceElement[])throwable.getStackTrace());
    }

    @Test
    public void testCircularSuppressedExceptions() {
        Exception e1 = new Exception();
        Exception e2 = new Exception();
        e2.addSuppressed(e1);
        e1.addSuppressed(e2);
        LogManager.getLogger().error("Error", (Throwable)e1);
    }

    @Test
    public void testSuppressedExceptions() {
        Exception e = new Exception("Root exception");
        e.addSuppressed(new IOException("Suppressed #1"));
        e.addSuppressed(new IOException("Suppressed #2"));
        LogManager.getLogger().error("Error", (Throwable)e);
        ThrowableProxy proxy = new ThrowableProxy((Throwable)e);
        String extendedStackTraceAsString = proxy.getExtendedStackTraceAsString("same suffix");
        Assertions.assertTrue((boolean)extendedStackTraceAsString.contains("\tSuppressed: java.io.IOException: Suppressed #1"));
        Assertions.assertTrue((boolean)extendedStackTraceAsString.contains("\tSuppressed: java.io.IOException: Suppressed #1"));
    }

    @Test
    public void testCauseSuppressedExceptions() {
        Exception cause = new Exception("Nested exception");
        cause.addSuppressed(new IOException("Suppressed #1"));
        cause.addSuppressed(new IOException("Suppressed #2"));
        LogManager.getLogger().error("Error", (Throwable)new Exception(cause));
        ThrowableProxy proxy = new ThrowableProxy((Throwable)new Exception("Root exception", cause));
        String extendedStackTraceAsString = proxy.getExtendedStackTraceAsString("same suffix");
        Assertions.assertTrue((boolean)extendedStackTraceAsString.contains("\tSuppressed: java.io.IOException: Suppressed #1"));
        Assertions.assertTrue((boolean)extendedStackTraceAsString.contains("\tSuppressed: java.io.IOException: Suppressed #1"));
    }

    @Test
    public void testCircularSuppressedNestedException() {
        Exception e1 = new Exception();
        Exception e2 = new Exception(e1);
        e2.addSuppressed(e1);
        e1.addSuppressed(e2);
        LogManager.getLogger().error("Error", (Throwable)e1);
    }

    @Test
    public void testCircularCauseExceptions() {
        Exception e1 = new Exception();
        Exception e2 = new Exception(e1);
        e1.initCause(e2);
        LogManager.getLogger().error("Error", (Throwable)e1);
    }

    static class Fixture {
        @JsonProperty
        ThrowableProxy proxy = new ThrowableProxy((Throwable)new IOException("test"));

        Fixture() {
        }
    }

    public static class AlwaysThrowsError {
        static {
            throw new Error("I always throw an Error when initialized");
        }
    }
}

