/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.filter.MutableThreadContextMapFilter;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MutableThreadContextMapFilterTest
implements MutableThreadContextMapFilter.FilterConfigUpdateListener {
    static final String CONFIG = "log4j2-mutableFilter.xml";
    static LoggerContext loggerContext = null;
    static File targetFile = new File("target/test-classes/testConfig.json");
    static Path target = targetFile.toPath();
    CountDownLatch updated = new CountDownLatch(1);

    @AfterEach
    public void after() {
        try {
            Files.deleteIfExists(target);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ThreadContext.clearMap();
        loggerContext.stop();
        loggerContext = null;
    }

    @Test
    public void filterTest() throws Exception {
        System.setProperty("configLocation", "target/test-classes/testConfig.json");
        ThreadContext.put((String)"loginId", (String)"rgoers");
        Path source = new File("target/test-classes/emptyConfig.json").toPath();
        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        long fileTime = targetFile.lastModified() - 1000L;
        Assertions.assertTrue((boolean)targetFile.setLastModified(fileTime));
        loggerContext = Configurator.initialize(null, (String)CONFIG);
        Assertions.assertNotNull((Object)loggerContext);
        Appender app = loggerContext.getConfiguration().getAppender("List");
        Assertions.assertNotNull((Object)app);
        Assertions.assertTrue((boolean)(app instanceof ListAppender));
        MutableThreadContextMapFilter filter = (MutableThreadContextMapFilter)loggerContext.getConfiguration().getFilter();
        Assertions.assertNotNull((Object)filter);
        filter.registerListener((MutableThreadContextMapFilter.FilterConfigUpdateListener)this);
        Logger logger = loggerContext.getLogger("Test");
        logger.debug("This is a test");
        Assertions.assertEquals((int)0, (int)((ListAppender)app).getEvents().size());
        source = new File("target/test-classes/filterConfig.json").toPath();
        String msg = null;
        boolean copied = false;
        for (int i = 0; i < 5 && !copied; ++i) {
            Thread.sleep(100 + 100 * i);
            try {
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                copied = true;
                continue;
            }
            catch (Exception ex) {
                msg = ex.getMessage();
            }
        }
        Assertions.assertTrue((boolean)copied, (String)("File not copied: " + msg));
        Assertions.assertNotEquals((long)fileTime, (long)targetFile.lastModified());
        if (!this.updated.await(5L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"File update was not detected");
        }
        logger.debug("This is a test");
        Assertions.assertEquals((int)1, (int)((ListAppender)app).getEvents().size());
    }

    public void onEvent() {
        this.updated.countDown();
    }
}

