/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.MapFilter;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MapFilterTest {
    @Test
    public void testFilter() {
        KeyValuePair[] pairs = new KeyValuePair[]{new KeyValuePair("FromAccount", "211000"), new KeyValuePair("ToAccount", "123456")};
        MapFilter filter = MapFilter.createFilter((KeyValuePair[])pairs, (String)"and", null, null);
        Assertions.assertNotNull((Object)filter);
        filter.start();
        StringMapMessage msg = new StringMapMessage();
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "211000");
        msg.put("Amount", "1000.00");
        Assertions.assertTrue((boolean)filter.isStarted());
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, (Message)msg, null));
        msg.put("ToAccount", "111111");
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.ERROR, null, (Message)msg, null));
        filter = MapFilter.createFilter((KeyValuePair[])pairs, (String)"or", null, null);
        Assertions.assertNotNull((Object)filter);
        filter.start();
        msg = new StringMapMessage();
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "211000");
        msg.put("Amount", "1000.00");
        Assertions.assertTrue((boolean)filter.isStarted());
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, (Message)msg, null));
        msg.put("ToAccount", "111111");
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.ERROR, null, (Message)msg, null));
    }

    @Test
    @LoggerContextSource(value="log4j2-mapfilter.xml")
    public void testConfig(Configuration config, @Named(value="LIST") ListAppender app) {
        Filter filter = config.getFilter();
        Assertions.assertNotNull((Object)filter, (String)"No MapFilter");
        Assertions.assertTrue((boolean)(filter instanceof MapFilter), (String)"Not a MapFilter");
        MapFilter mapFilter = (MapFilter)filter;
        Assertions.assertFalse((boolean)mapFilter.isAnd(), (String)"Should not be And filter");
        IndexedReadOnlyStringMap map = mapFilter.getStringMap();
        Assertions.assertNotNull((Object)map, (String)"No Map");
        Assertions.assertFalse((boolean)map.isEmpty(), (String)"No elements in Map");
        Assertions.assertEquals((int)1, (int)map.size(), (String)"Incorrect number of elements in Map");
        Assertions.assertTrue((boolean)map.containsKey("eventId"), (String)"Map does not contain key eventId");
        Assertions.assertEquals((int)2, (int)((Collection)map.getValue("eventId")).size(), (String)"List does not contain 2 elements");
        Logger logger = LogManager.getLogger(MapFilterTest.class);
        HashMap<String, String> eventMap = new HashMap<String, String>();
        eventMap.put("eventId", "Login");
        logger.debug((Message)new StringMapMessage(eventMap));
        List<String> msgs = app.getMessages();
        Assertions.assertNotNull(msgs, (String)"No messages");
        Assertions.assertFalse((boolean)msgs.isEmpty(), (String)"No messages");
    }
}

