/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class TestNoLanguages {
    private LoggerContext ctx = null;

    @AfterEach
    public void cleanup() {
        System.clearProperty("log4j.configurationFile");
        if (this.ctx != null) {
            Configurator.shutdown((LoggerContext)this.ctx);
            this.ctx = null;
        }
    }

    @Test
    public void testBuilderWithScripts() throws Exception {
        String script = "if (logEvent.getLoggerName().equals(\"NoLocation\")) {\n                return \"NoLocation\";\n            } else if (logEvent.getMarker() != null && logEvent.getMarker().isInstanceOf(\"FLOW\")) {\n                return \"Flow\";\n            } else {\n                return null;\n            }";
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(Level.ERROR);
        builder.setConfigurationName("BuilderTest");
        builder.add(builder.newScriptFile("filter.groovy", "target/test-classes/scripts/filter.groovy").addIsWatched(true));
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addComponent(builder.newComponent("ScriptPatternSelector").addAttribute("defaultPattern", "[%-5level] %c{1.} %C{1.}.%M.%L %msg%n").addComponent(builder.newComponent("PatternMatch").addAttribute("key", "NoLocation").addAttribute("pattern", "[%-5level] %c{1.} %msg%n")).addComponent(builder.newComponent("PatternMatch").addAttribute("key", "FLOW").addAttribute("pattern", "[%-5level] %c{1.} ====== %C{1.}.%M:%L %msg ======%n")).addComponent(builder.newComponent("selectorScript", "Script", "if (logEvent.getLoggerName().equals(\"NoLocation\")) {\n                return \"NoLocation\";\n            } else if (logEvent.getMarker() != null && logEvent.getMarker().isInstanceOf(\"FLOW\")) {\n                return \"Flow\";\n            } else {\n                return null;\n            }").addAttribute("language", "beanshell"))));
        appenderBuilder.add((FilterComponentBuilder)builder.newFilter("ScriptFilter", Filter.Result.DENY, Filter.Result.NEUTRAL).addComponent(builder.newComponent("ScriptRef").addAttribute("ref", "filter.groovy")));
        builder.add(appenderBuilder);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("org.apache.logging.log4j", Level.DEBUG).add(builder.newAppenderRef("Stdout"))).addAttribute("additivity", false));
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.ERROR).add(builder.newAppenderRef("Stdout")));
        this.ctx = Configurator.initialize((Configuration)((Configuration)builder.build()));
        Configuration config = this.ctx.getConfiguration();
        Assertions.assertNull((Object)config.getScriptManager());
    }
}

