/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import com.sun.management.UnixOperatingSystemMXBean;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.net.UrlConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigurationSourceTest {
    @Test
    public void testJira_LOG4J2_2770_byteArray() throws Exception {
        ConfigurationSource configurationSource = new ConfigurationSource((InputStream)new ByteArrayInputStream(new byte[]{97, 98}));
        Assertions.assertNotNull((Object)configurationSource.resetInputStream());
    }

    @Test
    public void testNoJarFileLeak() throws Exception {
        Path original = Paths.get("target", "test-classes", "jarfile.jar");
        Path copy = Paths.get("target", "test-classes", "jarfile-copy.jar");
        Files.copy(original, copy, new CopyOption[0]);
        URL jarUrl = new URL("jar:" + copy.toUri().toURL() + "!/config/console.xml");
        long expected = this.getOpenFileDescriptorCount();
        UrlConnectionFactory.createConnection((URL)jarUrl).getInputStream().close();
        Assertions.assertEquals((long)expected, (long)this.getOpenFileDescriptorCount());
        try {
            Files.delete(copy);
        }
        catch (IOException e) {
            Assertions.fail((Throwable)e);
        }
    }

    private long getOpenFileDescriptorCount() {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        if (os instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)os).getOpenFileDescriptorCount();
        }
        return 0L;
    }
}

