/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.YieldingWaitStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLogger;
import org.apache.logging.log4j.core.async.AsyncLoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.async.AsyncLoggerDisruptor;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactoryConfigTest;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.Assertions;

@Category(value={AsyncLoggers.class})
public class AsyncWaitStrategyFactoryConfigGlobalLoggersTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
        System.setProperty("log4j.configurationFile", "AsyncWaitStrategyFactoryConfigGlobalLoggerTest.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("Log4jContextSelector");
        System.clearProperty("log4j.configurationFile");
    }

    @Ignore(value="This test succeeds when run individually but fails when run by Surefire with all other tests")
    @Test
    public void testConfigWaitStrategyAndFactory() throws Exception {
        AsyncLogger logger = (AsyncLogger)LogManager.getLogger((String)"com.foo.Bar");
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        MatcherAssert.assertThat((String)"context is AsyncLoggerContext", (boolean)(context instanceof AsyncLoggerContext));
        AsyncWaitStrategyFactory asyncWaitStrategyFactory = context.getConfiguration().getAsyncWaitStrategyFactory();
        Assertions.assertEquals(AsyncWaitStrategyFactoryConfigTest.YieldingWaitStrategyFactory.class, asyncWaitStrategyFactory.getClass());
        MatcherAssert.assertThat((String)"factory is YieldingWaitStrategyFactory", (boolean)(asyncWaitStrategyFactory instanceof AsyncWaitStrategyFactoryConfigTest.YieldingWaitStrategyFactory));
        AsyncLoggerDisruptor delegate = logger.getAsyncLoggerDisruptor();
        Assertions.assertEquals(YieldingWaitStrategy.class, delegate.getWaitStrategy().getClass());
        MatcherAssert.assertThat((String)"waitstrategy is YieldingWaitStrategy", (boolean)(delegate.getWaitStrategy() instanceof YieldingWaitStrategy));
    }
}

