/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerDefaultLocationTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.configurationFile", "AsyncLoggerDefaultLocationTest.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Test
    public void testAsyncLogWritesToLog() throws Exception {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        ListAppender app = (ListAppender)context.getConfiguration().getAppender("List");
        Assert.assertNotNull((Object)((Object)app));
        Logger log = context.getLogger("com.foo.Bar");
        String msg = "Async logger msg with no location by default";
        log.info("Async logger msg with no location by default");
        context.stop();
        Assert.assertEquals((long)1L, (long)app.getEvents().size());
        LogEvent event = app.getEvents().get(0);
        Assert.assertFalse((String)"includeLocation should be false", (boolean)event.isIncludeLocation());
        Assert.assertNull((String)"Location data should not be present", (Object)event.getSource());
    }
}

