/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.List;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerContextSelectorTest {
    private static final String FQCN = AsyncLoggerContextSelectorTest.class.getName();

    @Test
    public void testContextReturnsAsyncLoggerContext() {
        AsyncLoggerContextSelector selector = new AsyncLoggerContextSelector();
        LoggerContext context = selector.getContext(FQCN, null, false);
        Assert.assertTrue((boolean)(context instanceof AsyncLoggerContext));
    }

    @Test
    public void testContext2ReturnsAsyncLoggerContext() {
        AsyncLoggerContextSelector selector = new AsyncLoggerContextSelector();
        LoggerContext context = selector.getContext(FQCN, null, false, null);
        Assert.assertTrue((boolean)(context instanceof AsyncLoggerContext));
    }

    @Test
    public void testLoggerContextsReturnsAsyncLoggerContext() {
        AsyncLoggerContextSelector selector = new AsyncLoggerContextSelector();
        selector.getContext(FQCN, null, false);
        List list = selector.getLoggerContexts();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof AsyncLoggerContext));
    }

    @Test
    public void testContextNameIsAsyncLoggerContextWithClassHashCode() {
        AsyncLoggerContextSelector selector = new AsyncLoggerContextSelector();
        LoggerContext context = selector.getContext(FQCN, null, false);
        int hash = this.getClass().getClassLoader().hashCode();
        String expectedContextName = "AsyncContext@" + Integer.toHexString(hash);
        Assert.assertEquals((Object)expectedContextName, (Object)context.getName());
    }

    @Test
    public void testDependentOnClassLoader() {
        AsyncLoggerContextSelector selector = new AsyncLoggerContextSelector();
        Assert.assertTrue((boolean)selector.isClassLoaderDependent());
    }
}

