/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.LoggerContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerConfigTest2 {
    @Test
    public void testConsecutiveReconfigure() throws Exception {
        System.setProperty("log4j.configurationFile", "AsyncLoggerConfigTest2.xml");
        File file = new File("target", "AsyncLoggerConfigTest2.log");
        Assert.assertTrue((String)"Deleted old file before test", (!file.exists() || file.delete() ? 1 : 0) != 0);
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        String msg = "Message before reconfig";
        log.info("Message before reconfig");
        LoggerContext ctx = LoggerContext.getContext((boolean)false);
        ctx.reconfigure();
        ctx.reconfigure();
        String msg2 = "Message after reconfig";
        log.info("Message after reconfig");
        CoreLoggerContexts.stopLoggerContext(file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        String line2 = reader.readLine();
        reader.close();
        file.delete();
        Assert.assertNotNull((String)"line1", (Object)line1);
        Assert.assertNotNull((String)"line2", (Object)line2);
        Assert.assertTrue((String)("line1 " + line1), (boolean)line1.contains("Message before reconfig"));
        Assert.assertTrue((String)("line2 " + line2), (boolean)line2.contains("Message after reconfig"));
    }
}

