/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.attribute.BasicFileAttributes;
import org.apache.logging.log4j.core.appender.rolling.action.CountingCondition;
import org.apache.logging.log4j.core.appender.rolling.action.DummyFileAttributes;
import org.apache.logging.log4j.core.appender.rolling.action.IfAccumulatedFileSize;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IfAccumulatedFileSizeTest {
    @Test
    public void testGetThresholdBytes() {
        Assertions.assertEquals((long)2L, (long)IfAccumulatedFileSizeTest.create("2B").getThresholdBytes());
        Assertions.assertEquals((long)3L, (long)IfAccumulatedFileSizeTest.create("3 B").getThresholdBytes());
        Assertions.assertEquals((long)2048L, (long)IfAccumulatedFileSizeTest.create("2KB").getThresholdBytes());
        Assertions.assertEquals((long)3072L, (long)IfAccumulatedFileSizeTest.create("3 KB").getThresholdBytes());
        Assertions.assertEquals((long)0x200000L, (long)IfAccumulatedFileSizeTest.create("2MB").getThresholdBytes());
        Assertions.assertEquals((long)0x300000L, (long)IfAccumulatedFileSizeTest.create("3 MB").getThresholdBytes());
        Assertions.assertEquals((long)0x80000000L, (long)IfAccumulatedFileSizeTest.create("2GB").getThresholdBytes());
        Assertions.assertEquals((long)0xC0000000L, (long)IfAccumulatedFileSizeTest.create("3 GB").getThresholdBytes());
        Assertions.assertEquals((long)0x20000000000L, (long)IfAccumulatedFileSizeTest.create("2TB").getThresholdBytes());
        Assertions.assertEquals((long)0x30000000000L, (long)IfAccumulatedFileSizeTest.create("3 TB").getThresholdBytes());
    }

    private static IfAccumulatedFileSize create(String size) {
        return IfAccumulatedFileSize.createFileSizeCondition((String)size, (PathCondition[])new PathCondition[0]);
    }

    @Test
    public void testNotAcceptOnExactMatch() {
        String[] sizes;
        for (String size : sizes = new String[]{"2KB", "3MB", "4GB", "5TB"}) {
            IfAccumulatedFileSize condition = IfAccumulatedFileSize.createFileSizeCondition((String)size, (PathCondition[])new PathCondition[0]);
            DummyFileAttributes attribs = new DummyFileAttributes();
            attribs.size = condition.getThresholdBytes();
            Assertions.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        }
    }

    @Test
    public void testAcceptIfExceedThreshold() {
        String[] sizes;
        for (String size : sizes = new String[]{"2KB", "3MB", "4GB", "5TB"}) {
            IfAccumulatedFileSize condition = IfAccumulatedFileSize.createFileSizeCondition((String)size, (PathCondition[])new PathCondition[0]);
            DummyFileAttributes attribs = new DummyFileAttributes();
            attribs.size = condition.getThresholdBytes() + 1L;
            Assertions.assertTrue((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        }
    }

    @Test
    public void testNotAcceptIfBelowThreshold() {
        String[] sizes;
        for (String size : sizes = new String[]{"2KB", "3MB", "4GB", "5TB"}) {
            IfAccumulatedFileSize condition = IfAccumulatedFileSize.createFileSizeCondition((String)size, (PathCondition[])new PathCondition[0]);
            DummyFileAttributes attribs = new DummyFileAttributes();
            attribs.size = condition.getThresholdBytes() - 1L;
            Assertions.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        }
    }

    @Test
    public void testAcceptOnceThresholdExceeded() {
        String[] sizes;
        DummyFileAttributes attribs = new DummyFileAttributes();
        for (String size : sizes = new String[]{"2KB", "3MB", "4GB", "5TB"}) {
            long quarter;
            IfAccumulatedFileSize condition = IfAccumulatedFileSize.createFileSizeCondition((String)size, (PathCondition[])new PathCondition[0]);
            attribs.size = quarter = condition.getThresholdBytes() / 4L;
            Assertions.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
            Assertions.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
            Assertions.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
            Assertions.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
            Assertions.assertTrue((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        }
    }

    @Test
    public void testAcceptCallsNestedConditionsOnlyIfPathAccepted() {
        long quarter;
        CountingCondition counter = new CountingCondition(true);
        IfAccumulatedFileSize condition = IfAccumulatedFileSize.createFileSizeCondition((String)"2KB", (PathCondition[])new PathCondition[]{counter});
        DummyFileAttributes attribs = new DummyFileAttributes();
        attribs.size = quarter = condition.getThresholdBytes() / 4L;
        Assertions.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        Assertions.assertEquals((int)0, (int)counter.getAcceptCount());
        Assertions.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        Assertions.assertEquals((int)0, (int)counter.getAcceptCount());
        Assertions.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        Assertions.assertEquals((int)0, (int)counter.getAcceptCount());
        Assertions.assertFalse((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        Assertions.assertEquals((int)0, (int)counter.getAcceptCount());
        Assertions.assertTrue((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        Assertions.assertEquals((int)1, (int)counter.getAcceptCount());
        Assertions.assertTrue((boolean)condition.accept(null, null, (BasicFileAttributes)attribs));
        Assertions.assertEquals((int)2, (int)counter.getAcceptCount());
    }

    @Test
    public void testBeforeTreeWalk() {
        CountingCondition counter = new CountingCondition(true);
        IfAccumulatedFileSize filter = IfAccumulatedFileSize.createFileSizeCondition((String)"2GB", (PathCondition[])new PathCondition[]{counter, counter, counter});
        filter.beforeFileTreeWalk();
        Assertions.assertEquals((int)3, (int)counter.getBeforeFileTreeWalkCount());
    }
}

