/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.OnStartupTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class RollingFileAppenderAccessTest {
    @Test
    public void testAccessManagerWithBuilder() throws IOException {
        try (LoggerContext ctx = LoggerContext.getContext((boolean)false);){
            Configuration config = ctx.getConfiguration();
            File file = File.createTempFile("RollingFileAppenderAccessTest", ".tmp");
            file.deleteOnExit();
            RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFileName(file.getCanonicalPath()).withFilePattern("FilePattern").setName("Name")).withPolicy((TriggeringPolicy)OnStartupTriggeringPolicy.createPolicy((long)1L)).setConfiguration(config)).build();
            RollingFileManager manager = (RollingFileManager)appender.getManager();
            Assert.assertNotNull((Object)manager.getRolloverStrategy());
            Assert.assertNotNull((Object)manager.getTriggeringPolicy());
        }
    }

    @Test
    public void testAccessManagerWithStrings() throws IOException {
        try (LoggerContext ctx = LoggerContext.getContext((boolean)false);){
            Configuration config = ctx.getConfiguration();
            File file = File.createTempFile("RollingFileAppenderAccessTest", ".tmp");
            file.deleteOnExit();
            RollingFileAppender appender = RollingFileAppender.createAppender((String)file.getCanonicalPath(), (String)"FilePattern", null, (String)"Name", null, null, null, (TriggeringPolicy)OnStartupTriggeringPolicy.createPolicy((long)1L), null, null, null, null, null, null, (Configuration)config);
            RollingFileManager manager = (RollingFileManager)appender.getManager();
            Assert.assertNotNull((Object)manager.getRolloverStrategy());
            Assert.assertNotNull((Object)manager.getTriggeringPolicy());
        }
    }
}

