/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.junit.CleanFolders;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class RollingAppenderDirectWriteStartupSizeTest {
    private static final String CONFIG = "log4j-rolling-direct-startup-size.xml";
    private static final String DIR = "target/rolling-direct-startup-size";
    private static final String FILE = "size-test.log";
    private static final String MESSAGE = "test message";
    @Rule
    public LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-direct-startup-size.xml");
    @Rule
    public CleanFolders cleanFolders = new CleanFolders(false, true, 10, "target/rolling-direct-startup-size");

    @BeforeClass
    public static void beforeClass() throws Exception {
        Path log = Paths.get(DIR, FILE);
        if (Files.exists(log, new LinkOption[0])) {
            Files.delete(log);
        }
        Files.createDirectories(log.getParent(), new FileAttribute[0]);
        Files.createFile(log, new FileAttribute[0]);
        Files.write(log, MESSAGE.getBytes(), new OpenOption[0]);
    }

    @Test
    public void testRollingFileAppenderWithReconfigure() throws Exception {
        RollingFileAppender rfAppender = this.loggerContextRule.getRequiredAppender("RollingFile", RollingFileAppender.class);
        RollingFileManager manager = (RollingFileManager)rfAppender.getManager();
        Assert.assertNotNull((Object)manager);
        Assert.assertEquals((String)"Existing file size not preserved on startup", (long)MESSAGE.getBytes().length, (long)manager.size);
    }
}

