/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderDeleteMaxDepthTest {
    private static final String CONFIG = "log4j-rolling-with-custom-delete-maxdepth.xml";
    private static final String DIR = "target/rolling-with-delete-depth/test";
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-with-custom-delete-maxdepth.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling-with-delete-depth/test");

    @Test
    public void testAppender() throws Exception {
        Path p1 = this.writeTextTo("target/rolling-with-delete-depth/test/1/test-4.log");
        Path p2 = this.writeTextTo("target/rolling-with-delete-depth/test/2/test-4.log");
        Path p3 = this.writeTextTo("target/rolling-with-delete-depth/test/1/2/test-4.log");
        Path p4 = this.writeTextTo("target/rolling-with-delete-depth/test/1/2/3/test-4.log");
        Logger logger = this.loggerContextRule.getLogger();
        for (int i = 0; i < 10; ++i) {
            logger.debug("This is a test message number " + i);
        }
        Thread.sleep(100L);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Dir target/rolling-with-delete-depth/test should exist", (boolean)dir.exists());
        Assert.assertTrue((String)"Dir target/rolling-with-delete-depth/test should contain files", (dir.listFiles().length > 0 ? 1 : 0) != 0);
        Object[] files = dir.listFiles();
        List<String> expected = Arrays.asList("1", "2", "test-1.log", "test-2.log", "test-3.log");
        Assert.assertEquals((String)Arrays.toString(files), (long)expected.size(), (long)files.length);
        for (Object file : files) {
            Assert.assertTrue((String)"test-4.log should have been deleted", (boolean)expected.contains(((File)file).getName()));
        }
        Assert.assertTrue((String)(p1 + " should not have been deleted"), (boolean)Files.exists(p1, new LinkOption[0]));
        Assert.assertTrue((String)(p2 + " should not have been deleted"), (boolean)Files.exists(p2, new LinkOption[0]));
        Assert.assertTrue((String)(p3 + " should not have been deleted"), (boolean)Files.exists(p3, new LinkOption[0]));
        Assert.assertTrue((String)(p4 + " should not have been deleted"), (boolean)Files.exists(p4, new LinkOption[0]));
    }

    private Path writeTextTo(String location) throws IOException {
        Path path = Paths.get(location, new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter buffy = Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]);){
            buffy.write("some text");
            buffy.newLine();
            buffy.flush();
        }
        return path;
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile("test-.?[2,4,6,8,0]\\.log\\.gz");
        for (int i = 0; i < 16; ++i) {
            String str = "test-" + i + ".log.gz";
            Matcher m = p.matcher(str);
            System.out.println(m.matches() + ": " + str);
        }
    }
}

