/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.xml.sax.SAXException;

@Ignore
@Category(value={Layouts.Xml.class})
public class XmlCompactFileAsyncAppenderValidationTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.configurationFile", "XmlCompactFileAsyncAppenderValidationTest.xml");
    }

    @Test
    public void validateXmlSchemaSimple() throws Exception {
        File file = new File("target", "XmlCompactFileAsyncAppenderValidationTest.log.xml");
        file.delete();
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        log.warn("Message 1");
        log.info("Message 2");
        log.debug("Message 3");
        CoreLoggerContexts.stopLoggerContext(file);
        this.validateXmlSchema(file);
    }

    @Test
    public void validateXmlSchemaNoEvents() throws Exception {
        File file = new File("target", "XmlCompactFileAsyncAppenderValidationTest.log.xml");
        file.delete();
        CoreLoggerContexts.stopLoggerContext(file);
        this.validateXmlSchema(file);
    }

    private void validateXmlSchema(File file) throws SAXException, IOException {
        URL schemaFile = this.getClass().getClassLoader().getResource("Log4j-events.xsd");
        StreamSource xmlFile = new StreamSource(file);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.validate(xmlFile);
    }
}

