/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-test2.xml")
public class LoggerUpdateTest {
    private final ListAppender app;

    public LoggerUpdateTest(@Named(value="List") ListAppender app) {
        this.app = app.clear();
    }

    @Test
    public void resetLevel(LoggerContext context) {
        Logger logger = context.getLogger("com.apache.test");
        logger.traceEntry();
        List<LogEvent> events = this.app.getEvents();
        Assertions.assertEquals((int)1, (int)events.size(), (String)("Incorrect number of events. Expected 1, actual " + events.size()));
        this.app.clear();
        LoggerContext ctx = LoggerContext.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(Level.DEBUG);
        ctx.updateLoggers();
        logger.traceEntry();
        events = this.app.getEvents();
        Assertions.assertEquals((int)0, (int)events.size(), (String)("Incorrect number of events. Expected 0, actual " + events.size()));
    }

    @Test
    public void testUpdateLoggersPropertyListeners(LoggerContext context) throws Exception {
        context.addPropertyChangeListener(evt -> {
            Assertions.assertEquals((Object)"config", (Object)evt.getPropertyName());
            Assertions.assertSame((Object)context, (Object)evt.getSource());
        });
        context.updateLoggers();
    }
}

