/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="json")
@LoggerContextSource(value="log4j-reference-level.json")
public class AppenderRefLevelJsonTest {
    private final ListAppender app1;
    private final ListAppender app2;
    Logger logger1;
    Logger logger2;
    Logger logger3;
    Marker testMarker = MarkerManager.getMarker((String)"TEST");

    public AppenderRefLevelJsonTest(LoggerContext context, @Named(value="LIST1") ListAppender first, @Named(value="LIST2") ListAppender second) {
        this.logger1 = context.getLogger("org.apache.logging.log4j.test1");
        this.logger2 = context.getLogger("org.apache.logging.log4j.test2");
        this.logger3 = context.getLogger("org.apache.logging.log4j.test3");
        this.app1 = first.clear();
        this.app2 = second.clear();
    }

    @Test
    public void logger1() {
        this.logger1.traceEntry();
        this.logger1.debug("debug message");
        this.logger1.error("Test Message");
        this.logger1.info("Info Message");
        this.logger1.warn("warn Message");
        this.logger1.traceExit();
        MatcherAssert.assertThat(this.app1.getEvents(), (Matcher)Matchers.hasSize((int)6));
        MatcherAssert.assertThat(this.app2.getEvents(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void logger2() {
        this.logger2.traceEntry();
        this.logger2.debug("debug message");
        this.logger2.error("Test Message");
        this.logger2.info("Info Message");
        this.logger2.warn("warn Message");
        this.logger2.traceExit();
        MatcherAssert.assertThat(this.app1.getEvents(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(this.app2.getEvents(), (Matcher)Matchers.hasSize((int)4));
    }

    @Test
    public void logger3() {
        this.logger3.traceEntry();
        this.logger3.debug(this.testMarker, "debug message");
        this.logger3.error("Test Message");
        this.logger3.info(this.testMarker, "Info Message");
        this.logger3.warn("warn Message");
        this.logger3.traceExit();
        MatcherAssert.assertThat(this.app1.getEvents(), (Matcher)Matchers.hasSize((int)4));
    }
}

