/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.datetime;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import org.apache.logging.log4j.util.Strings;
import org.junit.Assert;
import org.junit.Test;

public class FixedDateFormatTest {
    private boolean containsNanos(FixedDateFormat.FixedFormat fixedFormat) {
        String pattern = fixedFormat.getPattern();
        return pattern.endsWith("n") || pattern.matches(".+n+X*") || pattern.matches(".+n+Z*");
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorDisallowsNullFormat() {
        new FixedDateFormat(null, TimeZone.getDefault());
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorDisallowsNullTimeZone() {
        new FixedDateFormat(FixedDateFormat.FixedFormat.ABSOLUTE, null);
    }

    @Test
    public void testCreateIfSupported_customTimeZoneIfOptionsArrayWithTimeZoneElement() {
        FixedDateFormat fmt = FixedDateFormat.createIfSupported((String[])new String[]{FixedDateFormat.FixedFormat.DEFAULT.getPattern(), "+08:00", ""});
        Assert.assertEquals((Object)FixedDateFormat.FixedFormat.DEFAULT.getPattern(), (Object)fmt.getFormat());
        Assert.assertEquals((Object)TimeZone.getTimeZone("+08:00"), (Object)fmt.getTimeZone());
    }

    @Test
    public void testCreateIfSupported_defaultIfOptionsArrayEmpty() {
        FixedDateFormat fmt = FixedDateFormat.createIfSupported((String[])Strings.EMPTY_ARRAY);
        Assert.assertEquals((Object)FixedDateFormat.FixedFormat.DEFAULT.getPattern(), (Object)fmt.getFormat());
    }

    @Test
    public void testCreateIfSupported_defaultIfOptionsArrayNull() {
        FixedDateFormat fmt = FixedDateFormat.createIfSupported((String[])null);
        Assert.assertEquals((Object)FixedDateFormat.FixedFormat.DEFAULT.getPattern(), (Object)fmt.getFormat());
    }

    @Test
    public void testCreateIfSupported_defaultIfOptionsArrayWithSingleNullElement() {
        FixedDateFormat fmt = FixedDateFormat.createIfSupported((String[])new String[1]);
        Assert.assertEquals((Object)FixedDateFormat.FixedFormat.DEFAULT.getPattern(), (Object)fmt.getFormat());
        Assert.assertEquals((Object)TimeZone.getDefault(), (Object)fmt.getTimeZone());
    }

    @Test
    public void testCreateIfSupported_defaultTimeZoneIfOptionsArrayWithSecondNullElement() {
        FixedDateFormat fmt = FixedDateFormat.createIfSupported((String[])new String[]{FixedDateFormat.FixedFormat.DEFAULT.getPattern(), null, ""});
        Assert.assertEquals((Object)FixedDateFormat.FixedFormat.DEFAULT.getPattern(), (Object)fmt.getFormat());
        Assert.assertEquals((Object)TimeZone.getDefault(), (Object)fmt.getTimeZone());
    }

    @Test
    public void testCreateIfSupported_nonNullIfNameMatches() {
        for (FixedDateFormat.FixedFormat format : FixedDateFormat.FixedFormat.values()) {
            String[] options = new String[]{format.name()};
            Assert.assertNotNull((String)format.name(), (Object)FixedDateFormat.createIfSupported((String[])options));
        }
    }

    @Test
    public void testCreateIfSupported_nonNullIfPatternMatches() {
        for (FixedDateFormat.FixedFormat format : FixedDateFormat.FixedFormat.values()) {
            String[] options = new String[]{format.getPattern()};
            Assert.assertNotNull((String)format.name(), (Object)FixedDateFormat.createIfSupported((String[])options));
        }
    }

    @Test
    public void testCreateIfSupported_nullIfNameDoesNotMatch() {
        String[] options = new String[]{"DEFAULT3"};
        Assert.assertNull((String)"DEFAULT3", (Object)FixedDateFormat.createIfSupported((String[])options));
    }

    @Test
    public void testCreateIfSupported_nullIfPatternDoesNotMatch() {
        String[] options = new String[]{"y M d H m s"};
        Assert.assertNull((String)"y M d H m s", (Object)FixedDateFormat.createIfSupported((String[])options));
    }

    @Test
    public void testDaylightSavingToSummerTime() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse("2017-03-12 00:00:00 UTC"));
        SimpleDateFormat usCentral = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS", Locale.US);
        usCentral.setTimeZone(TimeZone.getTimeZone("US/Central"));
        SimpleDateFormat utc = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS", Locale.US);
        utc.setTimeZone(TimeZone.getTimeZone("UTC"));
        FixedDateFormat fixedUsCentral = FixedDateFormat.create((FixedDateFormat.FixedFormat)FixedDateFormat.FixedFormat.DEFAULT, (TimeZone)TimeZone.getTimeZone("US/Central"));
        FixedDateFormat fixedUtc = FixedDateFormat.create((FixedDateFormat.FixedFormat)FixedDateFormat.FixedFormat.DEFAULT, (TimeZone)TimeZone.getTimeZone("UTC"));
        String[][] expectedDstAndNoDst = new String[][]{{"2017-03-11 18:00:00,000", "2017-03-12 00:00:00,000"}, {"2017-03-11 19:00:00,000", "2017-03-12 01:00:00,000"}, {"2017-03-11 20:00:00,000", "2017-03-12 02:00:00,000"}, {"2017-03-11 21:00:00,000", "2017-03-12 03:00:00,000"}, {"2017-03-11 22:00:00,000", "2017-03-12 04:00:00,000"}, {"2017-03-11 23:00:00,000", "2017-03-12 05:00:00,000"}, {"2017-03-12 00:00:00,000", "2017-03-12 06:00:00,000"}, {"2017-03-12 01:00:00,000", "2017-03-12 07:00:00,000"}, {"2017-03-12 03:00:00,000", "2017-03-12 08:00:00,000"}, {"2017-03-12 04:00:00,000", "2017-03-12 09:00:00,000"}, {"2017-03-12 05:00:00,000", "2017-03-12 10:00:00,000"}, {"2017-03-12 06:00:00,000", "2017-03-12 11:00:00,000"}, {"2017-03-12 07:00:00,000", "2017-03-12 12:00:00,000"}, {"2017-03-12 08:00:00,000", "2017-03-12 13:00:00,000"}, {"2017-03-12 09:00:00,000", "2017-03-12 14:00:00,000"}, {"2017-03-12 10:00:00,000", "2017-03-12 15:00:00,000"}, {"2017-03-12 11:00:00,000", "2017-03-12 16:00:00,000"}, {"2017-03-12 12:00:00,000", "2017-03-12 17:00:00,000"}, {"2017-03-12 13:00:00,000", "2017-03-12 18:00:00,000"}, {"2017-03-12 14:00:00,000", "2017-03-12 19:00:00,000"}, {"2017-03-12 15:00:00,000", "2017-03-12 20:00:00,000"}, {"2017-03-12 16:00:00,000", "2017-03-12 21:00:00,000"}, {"2017-03-12 17:00:00,000", "2017-03-12 22:00:00,000"}, {"2017-03-12 18:00:00,000", "2017-03-12 23:00:00,000"}, {"2017-03-12 19:00:00,000", "2017-03-13 00:00:00,000"}, {"2017-03-12 20:00:00,000", "2017-03-13 01:00:00,000"}, {"2017-03-12 21:00:00,000", "2017-03-13 02:00:00,000"}, {"2017-03-12 22:00:00,000", "2017-03-13 03:00:00,000"}, {"2017-03-12 23:00:00,000", "2017-03-13 04:00:00,000"}, {"2017-03-13 00:00:00,000", "2017-03-13 05:00:00,000"}, {"2017-03-13 01:00:00,000", "2017-03-13 06:00:00,000"}, {"2017-03-13 02:00:00,000", "2017-03-13 07:00:00,000"}, {"2017-03-13 03:00:00,000", "2017-03-13 08:00:00,000"}, {"2017-03-13 04:00:00,000", "2017-03-13 09:00:00,000"}, {"2017-03-13 05:00:00,000", "2017-03-13 10:00:00,000"}, {"2017-03-13 06:00:00,000", "2017-03-13 11:00:00,000"}};
        TimeZone tz = TimeZone.getTimeZone("US/Central");
        for (int i = 0; i < 36; ++i) {
            Date date = calendar.getTime();
            Assert.assertEquals((String)"SimpleDateFormat TZ=US Central", (Object)expectedDstAndNoDst[i][0], (Object)usCentral.format(date));
            Assert.assertEquals((String)"SimpleDateFormat TZ=UTC", (Object)expectedDstAndNoDst[i][1], (Object)utc.format(date));
            Assert.assertEquals((String)"FixedDateFormat TZ=US Central", (Object)expectedDstAndNoDst[i][0], (Object)fixedUsCentral.format(date.getTime()));
            Assert.assertEquals((String)"FixedDateFormat TZ=UTC", (Object)expectedDstAndNoDst[i][1], (Object)fixedUtc.format(date.getTime()));
            calendar.add(11, 1);
        }
    }

    @Test
    public void testDaylightSavingToWinterTime() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse("2017-11-05 00:00:00 UTC"));
        SimpleDateFormat usCentral = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS", Locale.US);
        usCentral.setTimeZone(TimeZone.getTimeZone("US/Central"));
        SimpleDateFormat utc = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS", Locale.US);
        utc.setTimeZone(TimeZone.getTimeZone("UTC"));
        FixedDateFormat fixedUsCentral = FixedDateFormat.create((FixedDateFormat.FixedFormat)FixedDateFormat.FixedFormat.DEFAULT, (TimeZone)TimeZone.getTimeZone("US/Central"));
        FixedDateFormat fixedUtc = FixedDateFormat.create((FixedDateFormat.FixedFormat)FixedDateFormat.FixedFormat.DEFAULT, (TimeZone)TimeZone.getTimeZone("UTC"));
        String[][] expectedDstAndNoDst = new String[][]{{"2017-11-04 19:00:00,000", "2017-11-05 00:00:00,000"}, {"2017-11-04 20:00:00,000", "2017-11-05 01:00:00,000"}, {"2017-11-04 21:00:00,000", "2017-11-05 02:00:00,000"}, {"2017-11-04 22:00:00,000", "2017-11-05 03:00:00,000"}, {"2017-11-04 23:00:00,000", "2017-11-05 04:00:00,000"}, {"2017-11-05 00:00:00,000", "2017-11-05 05:00:00,000"}, {"2017-11-05 01:00:00,000", "2017-11-05 06:00:00,000"}, {"2017-11-05 01:00:00,000", "2017-11-05 07:00:00,000"}, {"2017-11-05 02:00:00,000", "2017-11-05 08:00:00,000"}, {"2017-11-05 03:00:00,000", "2017-11-05 09:00:00,000"}, {"2017-11-05 04:00:00,000", "2017-11-05 10:00:00,000"}, {"2017-11-05 05:00:00,000", "2017-11-05 11:00:00,000"}, {"2017-11-05 06:00:00,000", "2017-11-05 12:00:00,000"}, {"2017-11-05 07:00:00,000", "2017-11-05 13:00:00,000"}, {"2017-11-05 08:00:00,000", "2017-11-05 14:00:00,000"}, {"2017-11-05 09:00:00,000", "2017-11-05 15:00:00,000"}, {"2017-11-05 10:00:00,000", "2017-11-05 16:00:00,000"}, {"2017-11-05 11:00:00,000", "2017-11-05 17:00:00,000"}, {"2017-11-05 12:00:00,000", "2017-11-05 18:00:00,000"}, {"2017-11-05 13:00:00,000", "2017-11-05 19:00:00,000"}, {"2017-11-05 14:00:00,000", "2017-11-05 20:00:00,000"}, {"2017-11-05 15:00:00,000", "2017-11-05 21:00:00,000"}, {"2017-11-05 16:00:00,000", "2017-11-05 22:00:00,000"}, {"2017-11-05 17:00:00,000", "2017-11-05 23:00:00,000"}, {"2017-11-05 18:00:00,000", "2017-11-06 00:00:00,000"}, {"2017-11-05 19:00:00,000", "2017-11-06 01:00:00,000"}, {"2017-11-05 20:00:00,000", "2017-11-06 02:00:00,000"}, {"2017-11-05 21:00:00,000", "2017-11-06 03:00:00,000"}, {"2017-11-05 22:00:00,000", "2017-11-06 04:00:00,000"}, {"2017-11-05 23:00:00,000", "2017-11-06 05:00:00,000"}, {"2017-11-06 00:00:00,000", "2017-11-06 06:00:00,000"}, {"2017-11-06 01:00:00,000", "2017-11-06 07:00:00,000"}, {"2017-11-06 02:00:00,000", "2017-11-06 08:00:00,000"}, {"2017-11-06 03:00:00,000", "2017-11-06 09:00:00,000"}, {"2017-11-06 04:00:00,000", "2017-11-06 10:00:00,000"}, {"2017-11-06 05:00:00,000", "2017-11-06 11:00:00,000"}};
        TimeZone tz = TimeZone.getTimeZone("US/Central");
        for (int i = 0; i < 36; ++i) {
            Date date = calendar.getTime();
            Assert.assertEquals((String)"SimpleDateFormat TZ=US Central", (Object)expectedDstAndNoDst[i][0], (Object)usCentral.format(date));
            Assert.assertEquals((String)"SimpleDateFormat TZ=UTC", (Object)expectedDstAndNoDst[i][1], (Object)utc.format(date));
            Assert.assertEquals((String)"FixedDateFormat TZ=US Central", (Object)expectedDstAndNoDst[i][0], (Object)fixedUsCentral.format(date.getTime()));
            Assert.assertEquals((String)"FixedDateFormat TZ=UTC", (Object)expectedDstAndNoDst[i][1], (Object)fixedUtc.format(date.getTime()));
            calendar.add(11, 1);
        }
    }

    @Test
    public void testFixedFormat_getDatePatternLengthReturnsDatePatternLength() {
        Assert.assertEquals((long)"yyyyMMdd".length(), (long)FixedDateFormat.FixedFormat.COMPACT.getDatePatternLength());
        Assert.assertEquals((long)"yyyy-MM-dd ".length(), (long)FixedDateFormat.FixedFormat.DEFAULT.getDatePatternLength());
    }

    @Test
    public void testFixedFormat_getDatePatternLengthZeroIfNoDateInPattern() {
        Assert.assertEquals((long)0L, (long)FixedDateFormat.FixedFormat.ABSOLUTE.getDatePatternLength());
        Assert.assertEquals((long)0L, (long)FixedDateFormat.FixedFormat.ABSOLUTE_PERIOD.getDatePatternLength());
    }

    @Test
    public void testFixedFormat_getDatePatternNullIfNoDateInPattern() {
        Assert.assertNull((Object)FixedDateFormat.FixedFormat.ABSOLUTE.getDatePattern());
        Assert.assertNull((Object)FixedDateFormat.FixedFormat.ABSOLUTE_PERIOD.getDatePattern());
    }

    @Test
    public void testFixedFormat_getDatePatternReturnsDatePatternIfExists() {
        Assert.assertEquals((Object)"yyyyMMdd", (Object)FixedDateFormat.FixedFormat.COMPACT.getDatePattern());
        Assert.assertEquals((Object)"yyyy-MM-dd ", (Object)FixedDateFormat.FixedFormat.DEFAULT.getDatePattern());
    }

    @Test
    public void testFixedFormat_getFastDateFormatNonNullIfDateInPattern() {
        Assert.assertNotNull((Object)FixedDateFormat.FixedFormat.COMPACT.getFastDateFormat());
        Assert.assertNotNull((Object)FixedDateFormat.FixedFormat.DEFAULT.getFastDateFormat());
        Assert.assertEquals((Object)"yyyyMMdd", (Object)FixedDateFormat.FixedFormat.COMPACT.getFastDateFormat().getPattern());
        Assert.assertEquals((Object)"yyyy-MM-dd ", (Object)FixedDateFormat.FixedFormat.DEFAULT.getFastDateFormat().getPattern());
    }

    @Test
    public void testFixedFormat_getFastDateFormatNullIfNoDateInPattern() {
        Assert.assertNull((Object)FixedDateFormat.FixedFormat.ABSOLUTE.getFastDateFormat());
        Assert.assertNull((Object)FixedDateFormat.FixedFormat.ABSOLUTE_PERIOD.getFastDateFormat());
    }

    @Test
    public void testFormatLong() {
        long now = System.currentTimeMillis();
        long start = now - TimeUnit.HOURS.toMillis(25L);
        long end = now + TimeUnit.HOURS.toMillis(25L);
        for (FixedDateFormat.FixedFormat format : FixedDateFormat.FixedFormat.values()) {
            String pattern = format.getPattern();
            if (this.containsNanos(format) || format.getFixedTimeZoneFormat() != null) continue;
            SimpleDateFormat simpleDF = new SimpleDateFormat(pattern, Locale.getDefault());
            FixedDateFormat customTF = new FixedDateFormat(format, TimeZone.getDefault());
            for (long time = start; time < end; time += 12345L) {
                String actual = customTF.format(time);
                String expected = simpleDF.format(new Date(time));
                Assert.assertEquals((String)(format + "(" + pattern + ")/" + time), (Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void testFormatLong_goingBackInTime() {
        long now = System.currentTimeMillis();
        long start = now - TimeUnit.HOURS.toMillis(25L);
        long end = now + TimeUnit.HOURS.toMillis(25L);
        for (FixedDateFormat.FixedFormat format : FixedDateFormat.FixedFormat.values()) {
            String pattern = format.getPattern();
            if (this.containsNanos(format) || format.getFixedTimeZoneFormat() != null) continue;
            SimpleDateFormat simpleDF = new SimpleDateFormat(pattern, Locale.getDefault());
            FixedDateFormat customTF = new FixedDateFormat(format, TimeZone.getDefault());
            for (long time = end; time > start; time -= 12345L) {
                String actual = customTF.format(time);
                String expected = simpleDF.format(new Date(time));
                Assert.assertEquals((String)(format + "(" + pattern + ")/" + time), (Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void testFormatLong_goingBackInTime_DST() {
        Calendar instance = Calendar.getInstance(TimeZone.getTimeZone("EST"));
        instance.set(2017, 2, 12, 2, 0);
        long now = instance.getTimeInMillis();
        long start = now - TimeUnit.HOURS.toMillis(1L);
        long end = now + TimeUnit.HOURS.toMillis(1L);
        for (FixedDateFormat.FixedFormat format : FixedDateFormat.FixedFormat.values()) {
            String pattern = format.getPattern();
            if (this.containsNanos(format) || format.getFixedTimeZoneFormat() != null) continue;
            SimpleDateFormat simpleDF = new SimpleDateFormat(pattern, Locale.getDefault());
            FixedDateFormat customTF = new FixedDateFormat(format, TimeZone.getDefault());
            for (long time = end; time > start; time -= 12345L) {
                String actual = customTF.format(time);
                String expected = simpleDF.format(new Date(time));
                Assert.assertEquals((String)(format + "(" + pattern + ")/" + time), (Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void testFormatLongCharArrayInt() {
        long now = System.currentTimeMillis();
        long start = now - TimeUnit.HOURS.toMillis(25L);
        long end = now + TimeUnit.HOURS.toMillis(25L);
        char[] buffer = new char[128];
        for (FixedDateFormat.FixedFormat format : FixedDateFormat.FixedFormat.values()) {
            String pattern = format.getPattern();
            if (this.containsNanos(format) || format.getFixedTimeZoneFormat() != null) continue;
            SimpleDateFormat simpleDF = new SimpleDateFormat(pattern, Locale.getDefault());
            FixedDateFormat customTF = new FixedDateFormat(format, TimeZone.getDefault());
            for (long time = start; time < end; time += 12345L) {
                int length = customTF.format(time, buffer, 23);
                String actual = new String(buffer, 23, length);
                String expected = simpleDF.format(new Date(time));
                Assert.assertEquals((String)(format + "(" + pattern + ")/" + time), (Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void testFormatLongCharArrayInt_goingBackInTime() {
        long now = System.currentTimeMillis();
        long start = now - TimeUnit.HOURS.toMillis(25L);
        long end = now + TimeUnit.HOURS.toMillis(25L);
        char[] buffer = new char[128];
        for (FixedDateFormat.FixedFormat format : FixedDateFormat.FixedFormat.values()) {
            String pattern = format.getPattern();
            if (pattern.endsWith("n") || pattern.matches(".+n+X*") || pattern.matches(".+n+Z*") || format.getFixedTimeZoneFormat() != null) continue;
            SimpleDateFormat simpleDF = new SimpleDateFormat(pattern, Locale.getDefault());
            FixedDateFormat customTF = new FixedDateFormat(format, TimeZone.getDefault());
            for (long time = end; time > start; time -= 12345L) {
                int length = customTF.format(time, buffer, 23);
                String actual = new String(buffer, 23, length);
                String expected = simpleDF.format(new Date(time));
                Assert.assertEquals((String)(format + "(" + pattern + ")/" + time), (Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void testGetFormatReturnsConstructorFixedFormatPattern() {
        FixedDateFormat format = new FixedDateFormat(FixedDateFormat.FixedFormat.ABSOLUTE, TimeZone.getDefault());
        Assert.assertSame((Object)FixedDateFormat.FixedFormat.ABSOLUTE.getPattern(), (Object)format.getFormat());
    }
}

