/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.VariablesNotEmptyReplacementConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VariablesNotEmptyReplacementConverterTest {
    @Test
    public void testMarkerReplacement() {
        this.testReplacement("%marker", "");
    }

    @Test
    public void testMultipleMarkerReplacementEmpty() {
        this.testReplacement("<%marker>Foo</%marker>", "");
    }

    @Test
    public void testMultipleMarkerReplacementSomeEmpty() {
        this.testReplacement("<%marker>%msg</%marker>", "[<>This is a test</>]");
    }

    @Test
    public void testMultipleMarkerReplacement() {
        this.testReplacement("<%level>%msg</%level>", "[<DEBUG>This is a test</DEBUG>]");
    }

    @Test
    public void testMarkerSimpleNameReplacement() {
        this.testReplacement("%markerSimpleName", "");
    }

    @Test
    public void testLoggerNameReplacement() {
        this.testReplacement("%logger", "[" + VariablesNotEmptyReplacementConverterTest.class.getName() + "]");
    }

    private void testReplacement(String tag, String expectedValue) {
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(VariablesNotEmptyReplacementConverterTest.class.getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("This is a test")).build();
        StringBuilder sb = new StringBuilder();
        LoggerContext ctx = LoggerContext.getContext();
        String[] options = new String[]{"[" + tag + "]"};
        VariablesNotEmptyReplacementConverter converter = VariablesNotEmptyReplacementConverter.newInstance((Configuration)ctx.getConfiguration(), (String[])options);
        Assertions.assertNotNull((Object)converter);
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)expectedValue, (Object)sb.toString());
    }
}

