/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.parser;

import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.parser.JsonLogEventParser;
import org.apache.logging.log4j.core.parser.LogEventParserTest;
import org.apache.logging.log4j.core.parser.ParseException;
import org.junit.Before;
import org.junit.Test;

public class JsonLogEventParserTest
extends LogEventParserTest {
    private JsonLogEventParser parser;
    private static final String JSON = "{\n  \"timeMillis\" : 1493121664118,\n  \"instant\":{\"epochSecond\":1493121664,\"nanoOfSecond\":118000000},\n  \"thread\" : \"main\",\n  \"threadId\" : 1,\n  \"threadPriority\" : 5,\n  \"level\" : \"INFO\",\n  \"loggerName\" : \"HelloWorld\",\n  \"marker\" : {\n    \"name\" : \"child\",\n    \"parents\" : [ {\n      \"name\" : \"parent\",\n      \"parents\" : [ {\n        \"name\" : \"grandparent\"\n      } ]\n    } ]\n  },\n  \"message\" : \"Hello, world!\",\n  \"thrown\" : {\n    \"commonElementCount\" : 0,\n    \"message\" : \"error message\",\n    \"name\" : \"java.lang.RuntimeException\",\n    \"extendedStackTrace\" : [ {\n      \"class\" : \"logtest.Main\",\n      \"method\" : \"main\",\n      \"file\" : \"Main.java\",\n      \"line\" : 29,\n      \"exact\" : true,\n      \"location\" : \"classes/\",\n      \"version\" : \"?\"\n    } ]\n  },\n  \"contextStack\" : [ \"one\", \"two\" ],\n  \"loggerFqcn\" : \"org.apache.logging.log4j.spi.AbstractLogger\",\n  \"endOfBatch\" : false,\n  \"contextMap\" : {\n    \"bar\" : \"BAR\",\n    \"foo\" : \"FOO\"\n  },\n  \"source\" : {\n    \"class\" : \"logtest.Main\",\n    \"method\" : \"main\",\n    \"file\" : \"Main.java\",\n    \"line\" : 29\n  }\n}";

    @Before
    public void setup() {
        this.parser = new JsonLogEventParser();
    }

    @Test
    public void testString() throws ParseException {
        LogEvent logEvent = this.parser.parseFrom(JSON);
        this.assertLogEvent(logEvent);
    }

    @Test(expected=ParseException.class)
    public void testStringEmpty() throws ParseException {
        this.parser.parseFrom("");
    }

    @Test(expected=ParseException.class)
    public void testStringInvalidJson() throws ParseException {
        this.parser.parseFrom("foobar");
    }

    @Test(expected=ParseException.class)
    public void testStringJsonArray() throws ParseException {
        this.parser.parseFrom("[]");
    }

    @Test
    public void testEmptyObject() throws ParseException {
        this.parser.parseFrom("{}");
    }

    @Test(expected=ParseException.class)
    public void testStringWrongPropertyType() throws ParseException {
        this.parser.parseFrom("{\"threadId\":\"foobar\"}");
    }

    @Test
    public void testStringIgnoreInvalidProperty() throws ParseException {
        this.parser.parseFrom("{\"foo\":\"bar\"}");
    }

    @Test
    public void testByteArray() throws ParseException {
        LogEvent logEvent = this.parser.parseFrom(JSON.getBytes(StandardCharsets.UTF_8));
        this.assertLogEvent(logEvent);
    }

    @Test
    public void testByteArrayOffsetLength() throws ParseException {
        byte[] bytes = "abc{\n  \"timeMillis\" : 1493121664118,\n  \"instant\":{\"epochSecond\":1493121664,\"nanoOfSecond\":118000000},\n  \"thread\" : \"main\",\n  \"threadId\" : 1,\n  \"threadPriority\" : 5,\n  \"level\" : \"INFO\",\n  \"loggerName\" : \"HelloWorld\",\n  \"marker\" : {\n    \"name\" : \"child\",\n    \"parents\" : [ {\n      \"name\" : \"parent\",\n      \"parents\" : [ {\n        \"name\" : \"grandparent\"\n      } ]\n    } ]\n  },\n  \"message\" : \"Hello, world!\",\n  \"thrown\" : {\n    \"commonElementCount\" : 0,\n    \"message\" : \"error message\",\n    \"name\" : \"java.lang.RuntimeException\",\n    \"extendedStackTrace\" : [ {\n      \"class\" : \"logtest.Main\",\n      \"method\" : \"main\",\n      \"file\" : \"Main.java\",\n      \"line\" : 29,\n      \"exact\" : true,\n      \"location\" : \"classes/\",\n      \"version\" : \"?\"\n    } ]\n  },\n  \"contextStack\" : [ \"one\", \"two\" ],\n  \"loggerFqcn\" : \"org.apache.logging.log4j.spi.AbstractLogger\",\n  \"endOfBatch\" : false,\n  \"contextMap\" : {\n    \"bar\" : \"BAR\",\n    \"foo\" : \"FOO\"\n  },\n  \"source\" : {\n    \"class\" : \"logtest.Main\",\n    \"method\" : \"main\",\n    \"file\" : \"Main.java\",\n    \"line\" : 29\n  }\n}def".getBytes(StandardCharsets.UTF_8);
        LogEvent logEvent = this.parser.parseFrom(bytes, 3, bytes.length - 6);
        this.assertLogEvent(logEvent);
    }
}

