/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.Collections;
import java.util.HashMap;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.lookup.LookupResult;
import org.apache.logging.log4j.core.lookup.PropertiesLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertiesLookupTest {
    @Test
    public void testLookupContextProperty() {
        PropertiesLookup propertiesLookup = new PropertiesLookup(Property.EMPTY_ARRAY, Collections.singletonMap("A", "1"));
        Assertions.assertEquals((Object)"1", (Object)propertiesLookup.lookup("A"));
        LookupResult lookupResult = propertiesLookup.evaluate("A");
        Assertions.assertEquals((Object)"1", (Object)lookupResult.value());
        Assertions.assertFalse((boolean)lookupResult.isLookupEvaluationAllowedInValue());
    }

    @Test
    public void testLookupConfigProperty() {
        PropertiesLookup propertiesLookup = new PropertiesLookup(new Property[]{Property.createProperty((String)"A", (String)"1")}, Collections.emptyMap());
        Assertions.assertEquals((Object)"1", (Object)propertiesLookup.lookup("A"));
        LookupResult lookupResult = propertiesLookup.evaluate("A");
        Assertions.assertEquals((Object)"1", (Object)lookupResult.value());
        Assertions.assertTrue((boolean)lookupResult.isLookupEvaluationAllowedInValue());
    }

    @Test
    public void testConfigPropertiesPreferredOverContextProperties() {
        PropertiesLookup propertiesLookup = new PropertiesLookup(new Property[]{Property.createProperty((String)"A", (String)"1")}, Collections.singletonMap("A", "2"));
        Assertions.assertEquals((Object)"1", (Object)propertiesLookup.lookup("A"));
        LookupResult lookupResult = propertiesLookup.evaluate("A");
        Assertions.assertEquals((Object)"1", (Object)lookupResult.value());
        Assertions.assertTrue((boolean)lookupResult.isLookupEvaluationAllowedInValue());
    }

    @Test
    public void testEvaluateResultsSupportRecursiveEvaluation() {
        PropertiesLookup lookup = new PropertiesLookup(Collections.singletonMap("key", "value"));
        Assertions.assertFalse((boolean)lookup.evaluate("key").isLookupEvaluationAllowedInValue());
    }

    @Test
    public void testEvaluateReturnsNullWhenKeyIsNotFound() {
        PropertiesLookup lookup = new PropertiesLookup(Collections.emptyMap());
        Assertions.assertNull((Object)lookup.evaluate("key"));
    }

    @Test
    public void testEvaluateReturnsNullWhenKeyIsNull() {
        PropertiesLookup lookup = new PropertiesLookup(Collections.emptyMap());
        Assertions.assertNull((Object)lookup.evaluate(null));
    }

    @Test
    public void testContextPropertiesAreMutable() {
        HashMap<String, String> contextProperties = new HashMap<String, String>();
        PropertiesLookup lookup = new PropertiesLookup(Property.EMPTY_ARRAY, contextProperties);
        Assertions.assertNull((Object)lookup.evaluate("key"));
        contextProperties.put("key", "value");
        LookupResult result = lookup.evaluate("key");
        Assertions.assertEquals((Object)"value", (Object)result.value());
        Assertions.assertFalse((boolean)result.isLookupEvaluationAllowedInValue());
    }
}

