/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.BasicConfigurationFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.layout.LoggerFields;
import org.apache.logging.log4j.core.layout.Rfc5424Layout;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.junit.UsingAnyThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataCollectionMessage;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.ProcessIdUtil;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@UsingAnyThreadContext
public class Rfc5424LayoutTest {
    LoggerContext ctx = LoggerContext.getContext();
    Logger root = this.ctx.getRootLogger();
    private static final String PROCESSID = ProcessIdUtil.getProcessId();
    private static final String line1 = String.format("ATM %s - [RequestContext@3692 loginId=\"JohnDoe\"] starting mdc pattern test", PROCESSID);
    private static final String line2 = String.format("ATM %s - [RequestContext@3692 loginId=\"JohnDoe\"] empty mdc", PROCESSID);
    private static final String line3 = String.format("ATM %s - [RequestContext@3692 loginId=\"JohnDoe\"] filled mdc", PROCESSID);
    private static final String line4 = String.format("ATM %s Audit [Transfer@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"][RequestContext@3692 ipAddress=\"192.168.0.120\" loginId=\"JohnDoe\"] Transfer Complete", PROCESSID);
    private static final String lineEscaped3 = String.format("ATM %s - [RequestContext@3692 escaped=\"Testing escaping #012 \\\" \\] \\\"\" loginId=\"JohnDoe\"] filled mdc", PROCESSID);
    private static final String lineEscaped4 = String.format("ATM %s Audit [Transfer@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"][RequestContext@3692 escaped=\"Testing escaping #012 \\\" \\] \\\"\" ipAddress=\"192.168.0.120\" loginId=\"JohnDoe\"] Transfer Complete", PROCESSID);
    private static final String collectionLine1 = "[Transfer@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"]";
    private static final String collectionLine2 = "[Extra@18060 Item1=\"Hello\" Item2=\"World\"]";
    private static final String collectionLine3 = "[RequestContext@3692 ipAddress=\"192.168.0.120\" loginId=\"JohnDoe\"]";
    private static final String collectionEndOfLine = "Transfer Complete";
    static ConfigurationFactory cf = new BasicConfigurationFactory();

    @BeforeAll
    public static void setupClass() {
        StatusLogger.getLogger().setLevel(Level.OFF);
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)cf);
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
    }

    @AfterAll
    public static void cleanupClass() {
        ConfigurationFactory.removeConfigurationFactory((ConfigurationFactory)cf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayout() throws Exception {
        Object appender2;
        for (Object appender2 : this.root.getAppenders().values()) {
            this.root.removeAppender((Appender)appender2);
        }
        Rfc5424Layout layout = Rfc5424Layout.createLayout((Facility)Facility.LOCAL0, (String)"Event", (int)3692, (boolean)true, (String)"RequestContext", null, null, (boolean)true, null, (String)"ATM", null, (String)"key1, key2, locale", null, (String)"loginId", null, (boolean)true, null, null);
        appender2 = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender2.start();
        this.root.addAppender((Appender)appender2);
        this.root.setLevel(Level.DEBUG);
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        this.root.debug("starting mdc pattern test");
        this.root.debug("empty mdc");
        ThreadContext.put((String)"key1", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        this.root.debug("filled mdc");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        try {
            StructuredDataMessage msg = new StructuredDataMessage("Transfer@18060", collectionEndOfLine, "Audit");
            msg.put("ToAccount", "123456");
            msg.put("FromAccount", "123457");
            msg.put("Amount", "200.00");
            this.root.info(MarkerManager.getMarker((String)"EVENT"), (Message)msg);
            List<String> list = ((ListAppender)((Object)appender2)).getMessages();
            Assertions.assertTrue((boolean)list.get(0).endsWith(line1), (String)("Expected line 1 to end with: " + line1 + " Actual " + list.get(0)));
            Assertions.assertTrue((boolean)list.get(1).endsWith(line2), (String)("Expected line 2 to end with: " + line2 + " Actual " + list.get(1)));
            Assertions.assertTrue((boolean)list.get(2).endsWith(line3), (String)("Expected line 3 to end with: " + line3 + " Actual " + list.get(2)));
            Assertions.assertTrue((boolean)list.get(3).endsWith(line4), (String)("Expected line 4 to end with: " + line4 + " Actual " + list.get(3)));
            for (String frame : list) {
                int length = -1;
                int frameLength = frame.length();
                int firstSpacePosition = frame.indexOf(32);
                String messageLength = frame.substring(0, firstSpacePosition);
                try {
                    length = Integers.parseInt((String)messageLength);
                    Assertions.assertEquals((int)frameLength, (int)(messageLength.length() + length));
                }
                catch (NumberFormatException e) {
                    Assertions.fail((String)"Not a valid RFC 5425 frame");
                }
            }
            ((ListAppender)((Object)appender2)).clear();
            ThreadContext.remove((String)"loginId");
            this.root.debug("This is a test");
            list = ((ListAppender)((Object)appender2)).getMessages();
            Assertions.assertTrue((boolean)list.isEmpty(), (String)("No messages expected, found " + list.size()));
        }
        finally {
            this.root.removeAppender((Appender)appender2);
            appender2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCollection() throws Exception {
        Object appender2;
        for (Object appender2 : this.root.getAppenders().values()) {
            this.root.removeAppender((Appender)appender2);
        }
        Rfc5424Layout layout = Rfc5424Layout.createLayout((Facility)Facility.LOCAL0, (String)"Event", (int)3692, (boolean)true, (String)"RequestContext", null, null, (boolean)true, null, (String)"ATM", null, (String)"key1, key2, locale", null, (String)"loginId", null, (boolean)true, null, null);
        appender2 = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender2.start();
        this.root.addAppender((Appender)appender2);
        this.root.setLevel(Level.DEBUG);
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        try {
            StructuredDataMessage msg = new StructuredDataMessage("Transfer@18060", collectionEndOfLine, "Audit");
            msg.put("ToAccount", "123456");
            msg.put("FromAccount", "123457");
            msg.put("Amount", "200.00");
            StructuredDataMessage msg2 = new StructuredDataMessage("Extra@18060", null, "Audit");
            msg2.put("Item1", "Hello");
            msg2.put("Item2", "World");
            ArrayList<StructuredDataMessage> messages = new ArrayList<StructuredDataMessage>();
            messages.add(msg);
            messages.add(msg2);
            StructuredDataCollectionMessage collectionMessage = new StructuredDataCollectionMessage(messages);
            this.root.info(MarkerManager.getMarker((String)"EVENT"), (Message)collectionMessage);
            List<String> list = ((ListAppender)((Object)appender2)).getMessages();
            String result = list.get(0);
            Assertions.assertTrue((boolean)result.contains(collectionLine1), (String)("Expected line to contain [Transfer@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"], Actual " + result));
            Assertions.assertTrue((boolean)result.contains(collectionLine2), (String)("Expected line to contain [Extra@18060 Item1=\"Hello\" Item2=\"World\"], Actual " + result));
            Assertions.assertTrue((boolean)result.contains(collectionLine3), (String)("Expected line to contain [RequestContext@3692 ipAddress=\"192.168.0.120\" loginId=\"JohnDoe\"], Actual " + result));
            Assertions.assertTrue((boolean)result.endsWith(collectionEndOfLine), (String)("Expected line to end with: Transfer Complete Actual " + result));
            for (String frame : list) {
                int length = -1;
                int frameLength = frame.length();
                int firstSpacePosition = frame.indexOf(32);
                String messageLength = frame.substring(0, firstSpacePosition);
                try {
                    length = Integers.parseInt((String)messageLength);
                    Assertions.assertEquals((int)frameLength, (int)(messageLength.length() + length));
                }
                catch (NumberFormatException e) {
                    Assertions.fail((String)"Not a valid RFC 5425 frame");
                }
            }
            ((ListAppender)((Object)appender2)).clear();
        }
        finally {
            this.root.removeAppender((Appender)appender2);
            appender2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEscape() throws Exception {
        Object appender2;
        for (Object appender2 : this.root.getAppenders().values()) {
            this.root.removeAppender((Appender)appender2);
        }
        Rfc5424Layout layout = Rfc5424Layout.createLayout((Facility)Facility.LOCAL0, (String)"Event", (int)3692, (boolean)true, (String)"RequestContext", null, null, (boolean)true, (String)"#012", (String)"ATM", null, (String)"key1, key2, locale", null, (String)"loginId", null, (boolean)true, null, null);
        appender2 = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender2.start();
        this.root.addAppender((Appender)appender2);
        this.root.setLevel(Level.DEBUG);
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        this.root.debug("starting mdc pattern test");
        this.root.debug("empty mdc");
        ThreadContext.put((String)"escaped", (String)"Testing escaping \n \" ] \"");
        this.root.debug("filled mdc");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        try {
            StructuredDataMessage msg = new StructuredDataMessage("Transfer@18060", collectionEndOfLine, "Audit");
            msg.put("ToAccount", "123456");
            msg.put("FromAccount", "123457");
            msg.put("Amount", "200.00");
            this.root.info(MarkerManager.getMarker((String)"EVENT"), (Message)msg);
            List<String> list = ((ListAppender)((Object)appender2)).getMessages();
            Assertions.assertTrue((boolean)list.get(0).endsWith(line1), (String)("Expected line 1 to end with: " + line1 + " Actual " + list.get(0)));
            Assertions.assertTrue((boolean)list.get(1).endsWith(line2), (String)("Expected line 2 to end with: " + line2 + " Actual " + list.get(1)));
            Assertions.assertTrue((boolean)list.get(2).endsWith(lineEscaped3), (String)("Expected line 3 to end with: " + lineEscaped3 + " Actual " + list.get(2)));
            Assertions.assertTrue((boolean)list.get(3).endsWith(lineEscaped4), (String)("Expected line 4 to end with: " + lineEscaped4 + " Actual " + list.get(3)));
            ((ListAppender)((Object)appender2)).clear();
            ThreadContext.remove((String)"loginId");
            this.root.debug("This is a test");
            list = ((ListAppender)((Object)appender2)).getMessages();
            Assertions.assertTrue((boolean)list.isEmpty(), (String)("No messages expected, found " + list.size()));
        }
        finally {
            this.root.removeAppender((Appender)appender2);
            appender2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testException() throws Exception {
        Object appender2;
        for (Object appender2 : this.root.getAppenders().values()) {
            this.root.removeAppender((Appender)appender2);
        }
        Rfc5424Layout layout = Rfc5424Layout.createLayout((Facility)Facility.LOCAL0, (String)"Event", (int)3692, (boolean)true, (String)"RequestContext", null, null, (boolean)true, null, (String)"ATM", null, (String)"key1, key2, locale", null, (String)"loginId", (String)"%xEx", (boolean)true, null, null);
        appender2 = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender2.start();
        this.root.addAppender((Appender)appender2);
        this.root.setLevel(Level.DEBUG);
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        this.root.debug("starting mdc pattern test", (Throwable)new IllegalArgumentException("Test"));
        try {
            List<String> list = ((ListAppender)((Object)appender2)).getMessages();
            Assertions.assertTrue((list.size() > 1 ? 1 : 0) != 0, (String)"Not enough list entries");
            String string = list.get(1);
            Assertions.assertTrue((boolean)string.contains("IllegalArgumentException"), (String)("No Exception in " + string));
            ((ListAppender)((Object)appender2)).clear();
        }
        finally {
            this.root.removeAppender((Appender)appender2);
            appender2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMDCLoggerFields() throws Exception {
        for (Appender appender : this.root.getAppenders().values()) {
            this.root.removeAppender(appender);
        }
        LoggerFields[] loggerFields = new LoggerFields[]{LoggerFields.createLoggerFields((KeyValuePair[])new KeyValuePair[]{new KeyValuePair("source", "%C.%M")}, null, null, (boolean)false), LoggerFields.createLoggerFields((KeyValuePair[])new KeyValuePair[]{new KeyValuePair("source2", "%C.%M")}, null, null, (boolean)false)};
        Rfc5424Layout layout = Rfc5424Layout.createLayout((Facility)Facility.LOCAL0, (String)"Event", (int)3692, (boolean)true, (String)"RequestContext", null, null, (boolean)true, null, (String)"ATM", null, (String)"key1, key2, locale", null, null, null, (boolean)true, (LoggerFields[])loggerFields, null);
        ListAppender appender = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender.start();
        this.root.addAppender((Appender)appender);
        this.root.setLevel(Level.DEBUG);
        this.root.info("starting logger fields test");
        try {
            List<String> list = appender.getMessages();
            Assertions.assertTrue((list.size() > 0 ? 1 : 0) != 0, (String)"Not enough list entries");
            Assertions.assertTrue((boolean)list.get(0).contains("Rfc5424LayoutTest.testMDCLoggerFields"), (String)"No class/method");
            appender.clear();
        }
        finally {
            this.root.removeAppender((Appender)appender);
            appender.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoggerFields() {
        String[] fields = new String[]{"[BAZ@32473 baz=\"org.apache.logging.log4j.core.layout.Rfc5424LayoutTest.testLoggerFields\"]", "[RequestContext@3692 bar=\"org.apache.logging.log4j.core.layout.Rfc5424LayoutTest.testLoggerFields\"]", "[SD-ID@32473 source=\"org.apache.logging.log4j.core.layout.Rfc5424LayoutTest.testLoggerFields\"]"};
        List<String> expectedToContain = Arrays.asList(fields);
        for (Appender appender : this.root.getAppenders().values()) {
            this.root.removeAppender(appender);
        }
        LoggerFields[] loggerFields = new LoggerFields[]{LoggerFields.createLoggerFields((KeyValuePair[])new KeyValuePair[]{new KeyValuePair("source", "%C.%M")}, (String)"SD-ID", (String)"32473", (boolean)false), LoggerFields.createLoggerFields((KeyValuePair[])new KeyValuePair[]{new KeyValuePair("baz", "%C.%M"), new KeyValuePair("baz", "%C.%M")}, (String)"BAZ", (String)"32473", (boolean)false), LoggerFields.createLoggerFields((KeyValuePair[])new KeyValuePair[]{new KeyValuePair("bar", "%C.%M")}, null, null, (boolean)false)};
        Rfc5424Layout layout = Rfc5424Layout.createLayout((Facility)Facility.LOCAL0, (String)"Event", (int)3692, (boolean)true, (String)"RequestContext", null, null, (boolean)true, null, (String)"ATM", null, (String)"key1, key2, locale", null, null, null, (boolean)false, (LoggerFields[])loggerFields, null);
        ListAppender appender = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender.start();
        this.root.addAppender((Appender)appender);
        this.root.setLevel(Level.DEBUG);
        this.root.info("starting logger fields test");
        try {
            List<String> list = appender.getMessages();
            Assertions.assertTrue((list.size() > 0 ? 1 : 0) != 0, (String)"Not enough list entries");
            String message = list.get(0);
            Assertions.assertTrue((boolean)message.contains("Rfc5424LayoutTest.testLoggerFields"), (String)"No class/method");
            for (String value : expectedToContain) {
                Assertions.assertTrue((boolean)message.contains(value), (String)("Message expected to contain " + value + " but did not"));
            }
            appender.clear();
        }
        finally {
            this.root.removeAppender((Appender)appender);
            appender.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiscardEmptyLoggerFields() {
        String mdcId = "RequestContext";
        Arrays.asList("[BAZ@32473 baz=\"org.apache.logging.log4j.core.layout.Rfc5424LayoutTest.testLoggerFields\"][RequestContext@3692 bar=\"org.apache.logging.log4j.core.layout.Rfc5424LayoutTest.testLoggerFields\"]");
        for (Appender appender : this.root.getAppenders().values()) {
            this.root.removeAppender(appender);
        }
        LoggerFields[] loggerFields = new LoggerFields[]{LoggerFields.createLoggerFields((KeyValuePair[])new KeyValuePair[]{new KeyValuePair("dummy", ""), new KeyValuePair("empty", "")}, (String)"SD-ID", (String)"32473", (boolean)true), LoggerFields.createLoggerFields((KeyValuePair[])new KeyValuePair[]{new KeyValuePair("baz", "%C.%M"), new KeyValuePair("baz", "%C.%M")}, (String)"BAZ", (String)"32473", (boolean)false), LoggerFields.createLoggerFields((KeyValuePair[])new KeyValuePair[]{new KeyValuePair("bar", "%C.%M")}, null, null, (boolean)false)};
        Rfc5424Layout layout = Rfc5424Layout.createLayout((Facility)Facility.LOCAL0, (String)"Event", (int)3692, (boolean)true, (String)"RequestContext", null, null, (boolean)true, null, (String)"ATM", null, (String)"key1, key2, locale", null, null, null, (boolean)false, (LoggerFields[])loggerFields, null);
        ListAppender appender = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender.start();
        this.root.addAppender((Appender)appender);
        this.root.setLevel(Level.DEBUG);
        this.root.info("starting logger fields test");
        try {
            List<String> list = appender.getMessages();
            Assertions.assertTrue((list.size() > 0 ? 1 : 0) != 0, (String)"Not enough list entries");
            String message = list.get(0);
            Assertions.assertFalse((boolean)message.contains("SD-ID"), (String)"SD-ID should have been discarded");
            Assertions.assertTrue((boolean)message.contains("BAZ"), (String)"BAZ should have been included");
            Assertions.assertTrue((boolean)message.contains("RequestContext"), (String)"RequestContextshould have been included");
            appender.clear();
        }
        finally {
            this.root.removeAppender((Appender)appender);
            appender.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubstituteStructuredData() {
        Object appender2;
        String mdcId = "RequestContext";
        String expectedToContain = String.format("ATM %s MSG-ID - Message", PROCESSID);
        for (Object appender2 : this.root.getAppenders().values()) {
            this.root.removeAppender((Appender)appender2);
        }
        Rfc5424Layout layout = Rfc5424Layout.createLayout((Facility)Facility.LOCAL0, (String)"Event", (int)3692, (boolean)false, (String)"RequestContext", null, null, (boolean)true, null, (String)"ATM", (String)"MSG-ID", (String)"key1, key2, locale", null, null, null, (boolean)false, null, null);
        appender2 = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender2.start();
        this.root.addAppender((Appender)appender2);
        this.root.setLevel(Level.DEBUG);
        this.root.info("Message");
        try {
            List<String> list = ((ListAppender)((Object)appender2)).getMessages();
            Assertions.assertTrue((list.size() > 0 ? 1 : 0) != 0, (String)"Not enough list entries");
            String message = list.get(0);
            Assertions.assertTrue((boolean)message.contains(expectedToContain), (String)"Not the expected message received");
            ((ListAppender)((Object)appender2)).clear();
        }
        finally {
            this.root.removeAppender((Appender)appender2);
            appender2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParameterizedMessage() {
        Object appender2;
        for (Object appender2 : this.root.getAppenders().values()) {
            this.root.removeAppender((Appender)appender2);
        }
        Rfc5424Layout layout = Rfc5424Layout.createLayout((Facility)Facility.LOCAL0, (String)"Event", (int)3692, (boolean)true, (String)"RequestContext", null, null, (boolean)true, null, (String)"ATM", null, (String)"key1, key2, locale", null, null, null, (boolean)true, null, null);
        appender2 = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender2.start();
        this.root.addAppender((Appender)appender2);
        this.root.setLevel(Level.DEBUG);
        this.root.info("Hello {}", (Object)"World");
        try {
            List<String> list = ((ListAppender)((Object)appender2)).getMessages();
            Assertions.assertTrue((list.size() > 0 ? 1 : 0) != 0, (String)"Not enough list entries");
            String message = list.get(0);
            Assertions.assertTrue((boolean)message.contains("Hello World"), (String)("Incorrect message. Expected - Hello World, Actual - " + message));
        }
        finally {
            this.root.removeAppender((Appender)appender2);
            appender2.stop();
        }
    }
}

