/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.ReusableMessageFactory;
import org.apache.logging.log4j.message.ReusableSimpleMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.util.FilteredObjectInputStream;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class MutableLogEventTest {
    private static final StringMap CONTEXT_DATA = MutableLogEventTest.createContextData();
    private static final ThreadContext.ContextStack STACK = new MutableThreadContextStack(Arrays.asList("abc", "xyz"));
    static boolean useObjectInputStream = false;

    private static StringMap createContextData() {
        SortedArrayStringMap result = new SortedArrayStringMap();
        result.putValue("a", (Object)"1");
        result.putValue("b", (Object)"2");
        return result;
    }

    @BeforeAll
    public static void setupClass() {
        try {
            Class.forName("java.io.ObjectInputFilter");
            useObjectInputStream = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testToImmutable() {
        MutableLogEvent logEvent = new MutableLogEvent();
        Assertions.assertNotSame((Object)logEvent, (Object)logEvent.toImmutable());
    }

    @Test
    public void testInitFromCopiesAllFields() {
        Log4jLogEvent source = Log4jLogEvent.newBuilder().setContextData(CONTEXT_DATA).setContextStack(STACK).setEndOfBatch(true).setIncludeLocation(true).setLevel(Level.FATAL).setLoggerFqcn("a.b.c.d.e").setLoggerName("my name is Logger").setMarker(MarkerManager.getMarker((String)"on your marks")).setMessage((Message)new SimpleMessage("msg in a bottle")).setNanoTime(1234567L).setSource(new StackTraceElement("myclass", "mymethod", "myfile", 123)).setThreadId(100L).setThreadName("threadname").setThreadPriority(10).setThrown((Throwable)new RuntimeException("run")).setTimeMillis(987654321L).build();
        MutableLogEvent mutable = new MutableLogEvent();
        mutable.initFrom((LogEvent)source);
        Assertions.assertEquals((Object)CONTEXT_DATA, (Object)mutable.getContextData(), (String)"contextMap");
        Assertions.assertEquals((Object)STACK, (Object)mutable.getContextStack(), (String)"stack");
        Assertions.assertTrue((boolean)mutable.isEndOfBatch(), (String)"endOfBatch");
        Assertions.assertTrue((boolean)mutable.isIncludeLocation(), (String)"IncludeLocation()");
        Assertions.assertEquals((Object)Level.FATAL, (Object)mutable.getLevel(), (String)"level");
        Assertions.assertEquals((Object)source.getLoggerFqcn(), (Object)mutable.getLoggerFqcn(), (String)"LoggerFqcn()");
        Assertions.assertEquals((Object)source.getLoggerName(), (Object)mutable.getLoggerName(), (String)"LoggerName");
        Assertions.assertEquals((Object)source.getMarker(), (Object)mutable.getMarker(), (String)"marker");
        Assertions.assertEquals((Object)source.getMessage(), (Object)mutable.getMessage(), (String)"msg");
        Assertions.assertEquals((long)source.getNanoTime(), (long)mutable.getNanoTime(), (String)"nano");
        Assertions.assertEquals((Object)source.getSource(), (Object)mutable.getSource(), (String)"src");
        Assertions.assertEquals((long)source.getThreadId(), (long)mutable.getThreadId(), (String)"tid");
        Assertions.assertEquals((Object)source.getThreadName(), (Object)mutable.getThreadName(), (String)"tname");
        Assertions.assertEquals((int)source.getThreadPriority(), (int)mutable.getThreadPriority(), (String)"tpriority");
        Assertions.assertEquals((Object)source.getThrown(), (Object)mutable.getThrown(), (String)"throwns");
        Assertions.assertEquals((Object)source.getThrownProxy(), (Object)mutable.getThrownProxy(), (String)"proxy");
        Assertions.assertEquals((long)source.getTimeMillis(), (long)mutable.getTimeMillis(), (String)"millis");
    }

    @Test
    public void testInitFromReusableCopiesFormatString() {
        Message message = ReusableMessageFactory.INSTANCE.newMessage("msg in a {}", (Object)"bottle");
        Log4jLogEvent source = Log4jLogEvent.newBuilder().setContextData(CONTEXT_DATA).setContextStack(STACK).setEndOfBatch(true).setIncludeLocation(true).setLevel(Level.FATAL).setLoggerFqcn("a.b.c.d.e").setLoggerName("my name is Logger").setMarker(MarkerManager.getMarker((String)"on your marks")).setMessage(message).setNanoTime(1234567L).setSource(new StackTraceElement("myclass", "mymethod", "myfile", 123)).setThreadId(100L).setThreadName("threadname").setThreadPriority(10).setThrown((Throwable)new RuntimeException("run")).setTimeMillis(987654321L).build();
        MutableLogEvent mutable = new MutableLogEvent();
        mutable.initFrom((LogEvent)source);
        Assertions.assertEquals((Object)"msg in a {}", (Object)mutable.getFormat(), (String)"format");
        Assertions.assertEquals((Object)"msg in a bottle", (Object)mutable.getFormattedMessage(), (String)"formatted");
        Assertions.assertArrayEquals((Object[])new String[]{"bottle"}, (Object[])mutable.getParameters(), (String)"parameters");
        Message memento = mutable.memento();
        Assertions.assertEquals((Object)"msg in a {}", (Object)memento.getFormat(), (String)"format");
        Assertions.assertEquals((Object)"msg in a bottle", (Object)memento.getFormattedMessage(), (String)"formatted");
        Assertions.assertArrayEquals((Object[])new String[]{"bottle"}, (Object[])memento.getParameters(), (String)"parameters");
        Message eventMementoMessage = mutable.createMemento().getMessage();
        Assertions.assertEquals((Object)"msg in a {}", (Object)eventMementoMessage.getFormat(), (String)"format");
        Assertions.assertEquals((Object)"msg in a bottle", (Object)eventMementoMessage.getFormattedMessage(), (String)"formatted");
        Assertions.assertArrayEquals((Object[])new String[]{"bottle"}, (Object[])eventMementoMessage.getParameters(), (String)"parameters");
        Message log4JLogEventMessage = new Log4jLogEvent.Builder((LogEvent)mutable).build().getMessage();
        Assertions.assertEquals((Object)"msg in a {}", (Object)log4JLogEventMessage.getFormat(), (String)"format");
        Assertions.assertEquals((Object)"msg in a bottle", (Object)log4JLogEventMessage.getFormattedMessage(), (String)"formatted");
        Assertions.assertArrayEquals((Object[])new String[]{"bottle"}, (Object[])log4JLogEventMessage.getParameters(), (String)"parameters");
    }

    @Test
    public void testInitFromReusableObjectCopiesParameter() {
        Object param = new Object();
        Message message = ReusableMessageFactory.INSTANCE.newMessage(param);
        Log4jLogEvent source = Log4jLogEvent.newBuilder().setContextData(CONTEXT_DATA).setContextStack(STACK).setEndOfBatch(true).setIncludeLocation(true).setLevel(Level.FATAL).setLoggerFqcn("a.b.c.d.e").setLoggerName("my name is Logger").setMarker(MarkerManager.getMarker((String)"on your marks")).setMessage(message).setNanoTime(1234567L).setSource(new StackTraceElement("myclass", "mymethod", "myfile", 123)).setThreadId(100L).setThreadName("threadname").setThreadPriority(10).setThrown((Throwable)new RuntimeException("run")).setTimeMillis(987654321L).build();
        MutableLogEvent mutable = new MutableLogEvent();
        mutable.initFrom((LogEvent)source);
        Assertions.assertNull((Object)mutable.getFormat(), (String)"format");
        Assertions.assertEquals((Object)param.toString(), (Object)mutable.getFormattedMessage(), (String)"formatted");
        Assertions.assertArrayEquals((Object[])new Object[]{param}, (Object[])mutable.getParameters(), (String)"parameters");
        Message memento = mutable.memento();
        Assertions.assertNull((Object)memento.getFormat(), (String)"format");
        Assertions.assertEquals((Object)param.toString(), (Object)memento.getFormattedMessage(), (String)"formatted");
        Assertions.assertArrayEquals((Object[])new Object[]{param}, (Object[])memento.getParameters(), (String)"parameters");
    }

    @Test
    public void testClear() {
        MutableLogEvent mutable = new MutableLogEvent();
        ReusableSimpleMessage simpleMessage = new ReusableSimpleMessage();
        simpleMessage.set("");
        mutable.setMessage((Message)simpleMessage);
        Assertions.assertEquals((int)0, (int)mutable.getContextData().size(), (String)"context data");
        Assertions.assertNull((Object)mutable.getContextStack(), (String)"context stack");
        Assertions.assertFalse((boolean)mutable.isEndOfBatch(), (String)"end of batch");
        Assertions.assertFalse((boolean)mutable.isIncludeLocation(), (String)"incl loc");
        Assertions.assertSame((Object)Level.OFF, (Object)mutable.getLevel(), (String)"level");
        Assertions.assertNull((Object)mutable.getLoggerFqcn(), (String)"fqcn");
        Assertions.assertNull((Object)mutable.getLoggerName(), (String)"logger");
        Assertions.assertNull((Object)mutable.getMarker(), (String)"marker");
        Assertions.assertEquals((Object)mutable, (Object)mutable.getMessage(), (String)"msg");
        Assertions.assertEquals((long)0L, (long)mutable.getNanoTime(), (String)"nanoTm");
        Assertions.assertEquals((long)0L, (long)mutable.getThreadId(), (String)"tid");
        Assertions.assertNull((Object)mutable.getThreadName(), (String)"tname");
        Assertions.assertEquals((int)0, (int)mutable.getThreadPriority(), (String)"tpriority");
        Assertions.assertNull((Object)mutable.getThrown(), (String)"thrwn");
        Assertions.assertEquals((long)0L, (long)mutable.getTimeMillis(), (String)"timeMs");
        Assertions.assertNull((Object)mutable.getSource(), (String)"source");
        Assertions.assertNull((Object)mutable.getThrownProxy(), (String)"thrownProxy");
        mutable.setContextData(CONTEXT_DATA);
        mutable.setContextStack(STACK);
        mutable.setEndOfBatch(true);
        mutable.setIncludeLocation(true);
        mutable.setLevel(Level.WARN);
        mutable.setLoggerFqcn(this.getClass().getName());
        mutable.setLoggerName("loggername");
        mutable.setMarker(MarkerManager.getMarker((String)"marked man"));
        mutable.setMessage((Message)new ParameterizedMessage("message in a {}", (Object)"bottle"));
        mutable.setNanoTime(1234L);
        mutable.setThreadId(987L);
        mutable.setThreadName("ito");
        mutable.setThreadPriority(9);
        mutable.setThrown((Throwable)new Exception());
        mutable.setTimeMillis(56789L);
        Assertions.assertNotNull((Object)mutable.getContextStack(), (String)"context stack");
        Assertions.assertTrue((boolean)mutable.isEndOfBatch(), (String)"end of batch");
        Assertions.assertTrue((boolean)mutable.isIncludeLocation(), (String)"incl loc");
        Assertions.assertNotNull((Object)mutable.getLevel(), (String)"level");
        Assertions.assertNotNull((Object)mutable.getLoggerFqcn(), (String)"fqcn");
        Assertions.assertNotNull((Object)mutable.getLoggerName(), (String)"logger");
        Assertions.assertNotNull((Object)mutable.getMarker(), (String)"marker");
        Assertions.assertEquals((Object)new ParameterizedMessage("message in a {}", (Object)"bottle"), (Object)mutable.getMessage(), (String)"msg");
        Assertions.assertNotEquals((long)0L, (long)mutable.getNanoTime(), (String)"nanoTm");
        Assertions.assertNotEquals((long)0L, (long)mutable.getThreadId(), (String)"tid");
        Assertions.assertNotNull((Object)mutable.getThreadName(), (String)"tname");
        Assertions.assertNotEquals((int)0, (int)mutable.getThreadPriority(), (String)"tpriority");
        Assertions.assertNotNull((Object)mutable.getThrown(), (String)"thrwn");
        Assertions.assertNotEquals((long)0L, (long)mutable.getTimeMillis(), (String)"timeMs");
        Assertions.assertNotNull((Object)mutable.getSource(), (String)"source");
        Assertions.assertNotNull((Object)mutable.getThrownProxy(), (String)"thrownProxy");
        mutable.clear();
        Assertions.assertEquals((int)0, (int)mutable.getContextData().size(), (String)"context map");
        Assertions.assertNull((Object)mutable.getContextStack(), (String)"context stack");
        Assertions.assertSame((Object)Level.OFF, (Object)mutable.getLevel(), (String)"level");
        Assertions.assertNull((Object)mutable.getLoggerFqcn(), (String)"fqcn");
        Assertions.assertNull((Object)mutable.getLoggerName(), (String)"logger");
        Assertions.assertNull((Object)mutable.getMarker(), (String)"marker");
        Assertions.assertEquals((Object)mutable, (Object)mutable.getMessage(), (String)"msg");
        Assertions.assertNull((Object)mutable.getThrown(), (String)"thrwn");
        Assertions.assertNull((Object)mutable.getSource(), (String)"source");
        Assertions.assertNull((Object)mutable.getThrownProxy(), (String)"thrownProxy");
        Assertions.assertTrue((boolean)mutable.isEndOfBatch(), (String)"end of batch");
        Assertions.assertTrue((boolean)mutable.isIncludeLocation(), (String)"incl loc");
        Assertions.assertNotEquals((long)0L, (long)mutable.getNanoTime(), (String)"nanoTm");
        Assertions.assertNotEquals((long)0L, (long)mutable.getTimeMillis(), (String)"timeMs");
        Assertions.assertNotEquals((long)0L, (long)mutable.getThreadId(), (String)"tid");
        Assertions.assertNotNull((Object)mutable.getThreadName(), (String)"tname");
        Assertions.assertNotEquals((int)0, (int)mutable.getThreadPriority(), (String)"tpriority");
    }

    @Test
    public void testJavaIoSerializable() throws Exception {
        MutableLogEvent evt = new MutableLogEvent();
        evt.setContextData(CONTEXT_DATA);
        evt.setContextStack(STACK);
        evt.setEndOfBatch(true);
        evt.setIncludeLocation(true);
        evt.setLevel(Level.WARN);
        evt.setLoggerFqcn(this.getClass().getName());
        evt.setLoggerName("loggername");
        evt.setMarker(MarkerManager.getMarker((String)"marked man"));
        evt.setMessage((Message)new SimpleMessage("peace for all"));
        evt.setNanoTime(1234L);
        evt.setThreadId(987L);
        evt.setThreadName("ito");
        evt.setThreadPriority(9);
        evt.setTimeMillis(56789L);
        byte[] binary = this.serialize(evt);
        Log4jLogEvent evt2 = this.deserialize(binary);
        Assertions.assertEquals((long)evt.getTimeMillis(), (long)evt2.getTimeMillis());
        Assertions.assertEquals((Object)evt.getLoggerFqcn(), (Object)evt2.getLoggerFqcn());
        Assertions.assertEquals((Object)evt.getLevel(), (Object)evt2.getLevel());
        Assertions.assertEquals((Object)evt.getLoggerName(), (Object)evt2.getLoggerName());
        Assertions.assertEquals((Object)evt.getMarker(), (Object)evt2.getMarker());
        Assertions.assertEquals((Object)evt.getContextData(), (Object)evt2.getContextData());
        Assertions.assertEquals((Object)evt.getContextMap(), (Object)evt2.getContextMap());
        Assertions.assertEquals((Object)evt.getContextStack(), (Object)evt2.getContextStack());
        Assertions.assertEquals((Object)evt.getMessage(), (Object)evt2.getMessage());
        Assertions.assertNotNull((Object)evt2.getSource());
        Assertions.assertEquals((Object)evt.getSource(), (Object)evt2.getSource());
        Assertions.assertEquals((Object)evt.getThreadName(), (Object)evt2.getThreadName());
        Assertions.assertNull((Object)evt2.getThrown());
        Assertions.assertNull((Object)evt2.getThrownProxy());
        Assertions.assertEquals((Object)evt.isEndOfBatch(), (Object)evt2.isEndOfBatch());
        Assertions.assertEquals((Object)evt.isIncludeLocation(), (Object)evt2.isIncludeLocation());
        Assertions.assertNotEquals((long)evt.getNanoTime(), (long)evt2.getNanoTime());
        Assertions.assertEquals((long)0L, (long)evt2.getNanoTime());
    }

    @Test
    public void testJavaIoSerializableWithThrown() throws Exception {
        MutableLogEvent evt = new MutableLogEvent();
        evt.setContextData(CONTEXT_DATA);
        evt.setContextStack(STACK);
        evt.setEndOfBatch(true);
        evt.setIncludeLocation(true);
        evt.setLevel(Level.WARN);
        evt.setLoggerFqcn(this.getClass().getName());
        evt.setLoggerName("loggername");
        evt.setMarker(MarkerManager.getMarker((String)"marked man"));
        evt.setMessage((Message)new SimpleMessage("peace for all"));
        evt.setNanoTime(1234L);
        evt.setThreadId(987L);
        evt.setThreadName("ito");
        evt.setThreadPriority(9);
        evt.setThrown((Throwable)new Exception());
        evt.setTimeMillis(56789L);
        byte[] binary = this.serialize(evt);
        Log4jLogEvent evt2 = this.deserialize(binary);
        Assertions.assertEquals((long)evt.getTimeMillis(), (long)evt2.getTimeMillis());
        Assertions.assertEquals((Object)evt.getLoggerFqcn(), (Object)evt2.getLoggerFqcn());
        Assertions.assertEquals((Object)evt.getLevel(), (Object)evt2.getLevel());
        Assertions.assertEquals((Object)evt.getLoggerName(), (Object)evt2.getLoggerName());
        Assertions.assertEquals((Object)evt.getMarker(), (Object)evt2.getMarker());
        Assertions.assertEquals((Object)evt.getContextData(), (Object)evt2.getContextData());
        Assertions.assertEquals((Object)evt.getContextMap(), (Object)evt2.getContextMap());
        Assertions.assertEquals((Object)evt.getContextStack(), (Object)evt2.getContextStack());
        Assertions.assertEquals((Object)evt.getMessage(), (Object)evt2.getMessage());
        Assertions.assertNotNull((Object)evt2.getSource());
        Assertions.assertEquals((Object)evt.getSource(), (Object)evt2.getSource());
        Assertions.assertEquals((Object)evt.getThreadName(), (Object)evt2.getThreadName());
        Assertions.assertNull((Object)evt2.getThrown());
        Assertions.assertNotNull((Object)evt2.getThrownProxy());
        Assertions.assertEquals((Object)evt.getThrownProxy(), (Object)evt2.getThrownProxy());
        Assertions.assertEquals((Object)evt.isEndOfBatch(), (Object)evt2.isEndOfBatch());
        Assertions.assertEquals((Object)evt.isIncludeLocation(), (Object)evt2.isIncludeLocation());
        Assertions.assertNotEquals((long)evt.getNanoTime(), (long)evt2.getNanoTime());
        Assertions.assertEquals((long)0L, (long)evt2.getNanoTime());
    }

    private byte[] serialize(MutableLogEvent event) throws IOException {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(arr);
        out.writeObject(event);
        return arr.toByteArray();
    }

    private Log4jLogEvent deserialize(byte[] binary) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inArr = new ByteArrayInputStream(binary);
        ObjectInputStream in = useObjectInputStream ? new ObjectInputStream(inArr) : new FilteredObjectInputStream((InputStream)inArr);
        Log4jLogEvent result = (Log4jLogEvent)in.readObject();
        return result;
    }
}

