/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.properties;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.SetSystemProperty;

class PropertiesConfigurationTest {
    PropertiesConfigurationTest() {
    }

    @Test
    @LoggerContextSource(value="log4j2-properties.properties")
    void testPropertiesConfiguration(Configuration config) {
        Assertions.assertEquals((Object)config.getState(), (Object)LifeCycle.State.STARTED, (String)("Incorrect State: " + config.getState()));
        Map appenders = config.getAppenders();
        Assertions.assertNotNull((Object)appenders);
        Assertions.assertEquals((int)1, (int)appenders.size(), (String)("Incorrect number of Appenders: " + appenders.size()));
        Map loggers = config.getLoggers();
        Assertions.assertNotNull((Object)loggers);
        Assertions.assertEquals((int)2, (int)loggers.size(), (String)("Incorrect number of LoggerConfigs: " + loggers.size()));
        Filter filter = config.getFilter();
        Assertions.assertNotNull((Object)filter, (String)"No Filter");
        Assertions.assertTrue((boolean)(filter instanceof ThresholdFilter), (String)"Not a Threshold Filter");
        Logger logger = LogManager.getLogger(this.getClass());
        logger.info("Welcome to Log4j!");
    }

    @Test
    @LoggerContextSource(value="log4j2-properties-root-only.properties")
    void testRootLoggerOnly(Configuration config) {
        Assertions.assertEquals((Object)config.getState(), (Object)LifeCycle.State.STARTED, (String)("Incorrect State: " + config.getState()));
        Map appenders = config.getAppenders();
        Assertions.assertNotNull((Object)appenders);
        Assertions.assertEquals((int)appenders.size(), (int)1, (String)("Incorrect number of Appenders: " + appenders.size()));
        Map loggers = config.getLoggers();
        Assertions.assertNotNull((Object)loggers);
        Assertions.assertEquals((int)loggers.size(), (int)1, (String)("Incorrect number of LoggerConfigs: " + loggers.size()));
        Filter filter = config.getFilter();
        Assertions.assertNotNull((Object)filter, (String)"No Filter");
        MatcherAssert.assertThat((Object)filter, (Matcher)Matchers.instanceOf(ThresholdFilter.class));
        Logger logger = LogManager.getLogger(this.getClass());
        logger.info("Welcome to Log4j!");
    }

    @Test
    @LoggerContextSource(value="log4j-rolling.properties")
    void testRollingFile(Configuration config) {
        Assertions.assertEquals((Object)config.getState(), (Object)LifeCycle.State.STARTED, (String)("Incorrect State: " + config.getState()));
        Map appenders = config.getAppenders();
        Assertions.assertNotNull((Object)appenders);
        Assertions.assertEquals((int)appenders.size(), (int)3, (String)("Incorrect number of Appenders: " + appenders.size()));
        Map loggers = config.getLoggers();
        Assertions.assertNotNull((Object)loggers);
        Assertions.assertEquals((int)loggers.size(), (int)2, (String)("Incorrect number of LoggerConfigs: " + loggers.size()));
        Filter filter = config.getFilter();
        Assertions.assertNotNull((Object)filter, (String)"No Filter");
        MatcherAssert.assertThat((Object)filter, (Matcher)Matchers.instanceOf(ThresholdFilter.class));
        Logger logger = LogManager.getLogger(this.getClass());
        logger.info("Welcome to Log4j!");
    }

    @Test
    @LoggerContextSource(value="log4j2-properties-trailing-space-on-level.properties")
    void testTrailingSpaceOnLevel(Configuration config) {
        Assertions.assertEquals((Object)config.getState(), (Object)LifeCycle.State.STARTED, (String)("Incorrect State: " + config.getState()));
        Map appenders = config.getAppenders();
        Assertions.assertNotNull((Object)appenders);
        Assertions.assertEquals((int)appenders.size(), (int)1, (String)("Incorrect number of Appenders: " + appenders.size()));
        Map loggers = config.getLoggers();
        Assertions.assertNotNull((Object)loggers);
        Assertions.assertEquals((int)loggers.size(), (int)2, (String)("Incorrect number of LoggerConfigs: " + loggers.size()));
        Filter filter = config.getFilter();
        Assertions.assertNotNull((Object)filter, (String)"No Filter");
        MatcherAssert.assertThat((Object)filter, (Matcher)Matchers.instanceOf(ThresholdFilter.class));
        Logger logger = LogManager.getLogger(this.getClass());
        Assertions.assertEquals((Object)Level.DEBUG, (Object)logger.getLevel(), (String)("Incorrect level " + logger.getLevel()));
        logger.debug("Welcome to Log4j!");
    }

    @Test
    @LoggerContextSource(value="RootLoggerLevelAppenderTest.properties")
    void testRootLoggerLevelAppender(LoggerContext context, @Named ListAppender app) {
        context.getRootLogger().info("Hello world!");
        List<LogEvent> events = app.getEvents();
        Assertions.assertEquals((int)1, (int)events.size());
        Assertions.assertEquals((Object)"Hello world!", (Object)events.get(0).getMessage().getFormattedMessage());
    }

    @Test
    @LoggerContextSource(value="LoggerLevelAppenderTest.properties")
    void testLoggerLevelAppender(LoggerContext context, @Named ListAppender first, @Named ListAppender second) {
        context.getLogger(this.getClass()).atInfo().log("message");
        List<LogEvent> firstEvents = first.getEvents();
        List<LogEvent> secondEvents = second.getEvents();
        Assertions.assertEquals(firstEvents, secondEvents);
        Assertions.assertEquals((int)1, (int)firstEvents.size());
    }

    @SetSystemProperty(key="coreProps", value="DEBUG, first, second")
    @Test
    @LoggerContextSource(value="LoggerLevelSysPropsAppenderTest.properties")
    void testLoggerLevelSysPropsAppender(LoggerContext context, @Named ListAppender first, @Named ListAppender second, @Named ListAppender third) {
        context.getLogger(this.getClass()).atInfo().log("message");
        context.getLogger(this.getClass()).atDebug().log("debug message");
        context.getRootLogger().atInfo().log("test message");
        List<LogEvent> firstEvents = first.getEvents();
        List<LogEvent> secondEvents = second.getEvents();
        Assertions.assertEquals(firstEvents, secondEvents);
        Assertions.assertEquals((int)2, (int)firstEvents.size());
        List<LogEvent> thirdEvents = third.getEvents();
        Assertions.assertEquals((int)1, (int)thirdEvents.size());
    }
}

