/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="configPropertyTest.xml")
public class PropertyTest {
    @Test
    public void testEmptyAttribute(@Named(value="List") ListAppender app) throws Exception {
        Logger logger = LogManager.getLogger();
        logger.info("msg");
        List<String> messages = app.getMessages();
        Assertions.assertNotNull(messages, (String)"No Messages");
        Assertions.assertEquals((int)1, (int)messages.size(), (String)("message count" + messages));
        String expect = "1=elementValue,2=,a=,b=,3=attributeValue,4=attributeValue2,5=elementValue3,m=msg";
        Assertions.assertEquals((Object)"1=elementValue,2=,a=,b=,3=attributeValue,4=attributeValue2,5=elementValue3,m=msg", (Object)messages.get(0));
        app.clear();
    }

    @Test
    public void testNullValueIsConvertedToEmptyString() {
        Assertions.assertEquals((Object)"", (Object)Property.createProperty((String)"name", null).getValue());
    }

    @Test
    public void testIsValueNeedsLookup() {
        Assertions.assertTrue((boolean)Property.createProperty((String)"", (String)"${").isValueNeedsLookup(), (String)"with ${ as value");
        Assertions.assertTrue((boolean)Property.createProperty((String)"", (String)"blah${blah").isValueNeedsLookup(), (String)"with ${ in value");
        Assertions.assertFalse((boolean)Property.createProperty((String)"", (String)"").isValueNeedsLookup(), (String)"empty value");
        Assertions.assertFalse((boolean)Property.createProperty((String)"", (String)"blahblah").isValueNeedsLookup(), (String)"without ${ in value");
        Assertions.assertFalse((boolean)Property.createProperty((String)"", (String)"blahb{sys:lah").isValueNeedsLookup(), (String)"without $ in value");
        Assertions.assertFalse((boolean)Property.createProperty((String)"", (String)"blahb$sys:lah").isValueNeedsLookup(), (String)"without { in value");
    }
}

