/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
@LoggerContextSource(value="log4j-set-level.xml")
public class ConfiguratorSetLevelTest {
    private final ListAppender app1;
    private final LoggerContext loggerContext;
    private Logger logger1;

    public ConfiguratorSetLevelTest(LoggerContext context, @Named(value="LIST1") ListAppender first) {
        this.loggerContext = context;
        this.logger1 = context.getLogger("org.apache.logging");
        this.app1 = first.clear();
    }

    @Test
    public void testSetLevel() {
        ExtendedLogger logger = this.loggerContext.getLogger(ConfiguratorSetLevelTest.class);
        Configurator.setLevel((Logger)logger, (Level)Level.DEBUG);
        LoggerConfig loggerConfig = ((AbstractConfiguration)this.loggerContext.getConfiguration()).getLogger(ConfiguratorSetLevelTest.class.getName());
        Assertions.assertNotNull((Object)loggerConfig);
        Assertions.assertEquals((Object)Level.DEBUG, (Object)loggerConfig.getLevel());
        Assertions.assertEquals((int)0, (int)loggerConfig.getAppenderRefs().size());
        logger.trace("Test trace message");
        logger.debug("Test debug message");
        Assertions.assertEquals((int)1, (int)this.app1.getEvents().size());
    }
}

