/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.ThreadContextMapFilter;
import org.apache.logging.log4j.junit.CleanUpFiles;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.util.Unbox;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

@CleanUpFiles(value={"target/test-xml.log", "target/test-xinclude.log", "target/test-json.log", "target/test-yaml.log", "target/test-properties.log"})
class ConfigurationFactoryTest {
    static final String LOGGER_NAME = "org.apache.logging.log4j.test1.Test";
    static final String FILE_LOGGER_NAME = "org.apache.logging.log4j.test2.Test";
    static final String APPENDER_NAME = "STDOUT";

    ConfigurationFactoryTest() {
    }

    static void checkConfiguration(LoggerContext context) {
        Configuration configuration = context.getConfiguration();
        Map appenders = configuration.getAppenders();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)appenders), () -> Assertions.assertEquals((int)3, (int)appenders.size()), () -> Assertions.assertNotNull((Object)configuration.getLoggerContext()), () -> Assertions.assertEquals((Object)configuration.getRootLogger(), (Object)configuration.getLoggerConfig("")), () -> {
            NullPointerException cfr_ignored_0 = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> configuration.getLoggerConfig(null));
        }});
        Logger logger = context.getLogger(LOGGER_NAME);
        Assertions.assertEquals((Object)Level.DEBUG, (Object)logger.getLevel());
        Assertions.assertEquals((int)1, (int)logger.filterCount());
        Iterator filterIterator = logger.getFilters();
        Assertions.assertTrue((boolean)filterIterator.hasNext());
        Assertions.assertTrue((boolean)(filterIterator.next() instanceof ThreadContextMapFilter));
        Appender appender = (Appender)appenders.get(APPENDER_NAME);
        Assertions.assertTrue((boolean)(appender instanceof ConsoleAppender));
        Assertions.assertEquals((Object)APPENDER_NAME, (Object)appender.getName());
    }

    static void checkFileLogger(LoggerContext context, Path logFile) throws IOException {
        long currentThreadId = Thread.currentThread().getId();
        Logger logger = context.getLogger(FILE_LOGGER_NAME);
        logger.debug("Greetings from ConfigurationFactoryTest in thread#{}", (Object)Unbox.box((long)currentThreadId));
        List<String> lines = Files.readAllLines(logFile);
        Assertions.assertEquals((int)1, (int)lines.size());
        Assertions.assertTrue((boolean)lines.get(0).endsWith(Long.toString(currentThreadId)));
    }

    @Test
    @LoggerContextSource(value="log4j-test1.xml")
    void xml(LoggerContext context) throws IOException {
        ConfigurationFactoryTest.checkConfiguration(context);
        Path logFile = Paths.get("target", "test-xml.log");
        ConfigurationFactoryTest.checkFileLogger(context, logFile);
    }

    @Test
    @LoggerContextSource(value="log4j-xinclude.xml")
    void xinclude(LoggerContext context) throws IOException {
        ConfigurationFactoryTest.checkConfiguration(context);
        Path logFile = Paths.get("target", "test-xinclude.log");
        ConfigurationFactoryTest.checkFileLogger(context, logFile);
    }

    @Test
    @Tag(value="json")
    @LoggerContextSource(value="log4j-test1.json")
    void json(LoggerContext context) throws IOException {
        ConfigurationFactoryTest.checkConfiguration(context);
        Path logFile = Paths.get("target", "test-json.log");
        ConfigurationFactoryTest.checkFileLogger(context, logFile);
    }

    @Test
    @Tag(value="yaml")
    @LoggerContextSource(value="log4j-test1.yaml")
    void yaml(LoggerContext context) throws IOException {
        ConfigurationFactoryTest.checkConfiguration(context);
        Path logFile = Paths.get("target", "test-yaml.log");
        ConfigurationFactoryTest.checkFileLogger(context, logFile);
    }

    @Test
    @LoggerContextSource(value="log4j-test1.properties")
    void properties(LoggerContext context) throws IOException {
        ConfigurationFactoryTest.checkConfiguration(context);
        Path logFile = Paths.get("target", "test-properties.log");
        ConfigurationFactoryTest.checkFileLogger(context, logFile);
    }
}

