/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async.perftest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.async.perftest.IPerfTestRunner;
import org.apache.logging.log4j.core.async.perftest.MultiThreadPerfTest;
import org.apache.logging.log4j.core.async.perftest.PerfTest;
import org.apache.logging.log4j.core.async.perftest.RunLog4j1;
import org.apache.logging.log4j.core.async.perftest.RunLog4j2;
import org.apache.logging.log4j.core.async.perftest.RunLogback;
import org.apache.logging.log4j.core.util.Integers;

public class PerfTestDriver {
    private static final String DEFAULT_WAIT_STRATEGY = "Block";

    public static void main(String[] args) throws Exception {
        long start = System.nanoTime();
        List<Setup> tests = PerfTestDriver.selectTests();
        PerfTestDriver.runPerfTests(args, tests);
        System.out.printf("Done. Total duration: %.1f minutes%n", (double)(System.nanoTime() - start) / 6.0E10);
        PerfTestDriver.printRanking(tests.toArray(new Setup[tests.size()]));
    }

    private static List<Setup> selectTests() throws IOException {
        ArrayList<Setup> tests = new ArrayList<Setup>();
        String SYSCLOCK = "-Dlog4j.Clock=SystemClock";
        String ALL_ASYNC = "-DLog4jContextSelector=" + AsyncLoggerContextSelector.class.getName();
        String THREADNAME = "-DAsyncLogger.ThreadNameStrategy=" + System.getProperty("AsyncLogger.ThreadNameStrategy", "CACHED");
        PerfTestDriver.add(tests, 1, "perf3PlainNoLoc.xml", Runner.Log4j2, "Loggers all async", ALL_ASYNC, "-Dlog4j.Clock=SystemClock", THREADNAME);
        PerfTestDriver.add(tests, 1, "perf7MixedNoLoc.xml", Runner.Log4j2, "Loggers mixed sync/async", new String[0]);
        PerfTestDriver.add(tests, 1, "perf-logback.xml", Runner.Logback, "Sync", new String[0]);
        PerfTestDriver.add(tests, 1, "perf-log4j12.xml", Runner.Log4j12, "Sync", new String[0]);
        PerfTestDriver.add(tests, 1, "perf3PlainNoLoc.xml", Runner.Log4j2, "Sync", new String[0]);
        PerfTestDriver.add(tests, 1, "perf-logback-async.xml", Runner.Logback, "Async Appender", new String[0]);
        PerfTestDriver.add(tests, 1, "perf-log4j12-async.xml", Runner.Log4j12, "Async Appender", new String[0]);
        PerfTestDriver.add(tests, 1, "perf5AsyncApndNoLoc.xml", Runner.Log4j2, "Async Appender", new String[0]);
        int MAX_THREADS = 4;
        for (int i = 2; i <= 4; i *= 2) {
            PerfTestDriver.add(tests, i, "perf-logback.xml", Runner.Logback, "Sync", new String[0]);
            PerfTestDriver.add(tests, i, "perf-log4j12.xml", Runner.Log4j12, "Sync", new String[0]);
            PerfTestDriver.add(tests, i, "perf3PlainNoLoc.xml", Runner.Log4j2, "Sync", new String[0]);
            PerfTestDriver.add(tests, i, "perf-logback-async.xml", Runner.Logback, "Async Appender", new String[0]);
            PerfTestDriver.add(tests, i, "perf-log4j12-async.xml", Runner.Log4j12, "Async Appender", new String[0]);
            PerfTestDriver.add(tests, i, "perf5AsyncApndNoLoc.xml", Runner.Log4j2, "Async Appender", new String[0]);
            PerfTestDriver.add(tests, i, "perf3PlainNoLoc.xml", Runner.Log4j2, "Loggers all async", ALL_ASYNC, "-Dlog4j.Clock=SystemClock", THREADNAME);
            PerfTestDriver.add(tests, i, "perf7MixedNoLoc.xml", Runner.Log4j2, "Loggers mixed sync/async", new String[0]);
        }
        return tests;
    }

    private static void add(List<Setup> tests, int threadCount, String config, Runner runner, String name, String ... systemProperties) throws IOException {
        WaitStrategy wait = WaitStrategy.get();
        Class perfTest = threadCount == 1 ? PerfTest.class : MultiThreadPerfTest.class;
        Setup setup = new Setup(perfTest, runner, name, config, threadCount, wait, systemProperties);
        tests.add(setup);
    }

    private static void runPerfTests(String[] args, List<Setup> tests) throws IOException, InterruptedException, FileNotFoundException {
        String java = args.length > 0 ? args[0] : "java";
        int repeat = args.length > 1 ? Integers.parseInt((String)args[1]) : 5;
        int x = 0;
        for (Setup setup : tests) {
            System.out.print(setup.description());
            ProcessBuilder pb = setup.throughputTest(java);
            pb.redirectErrorStream(true);
            long t1 = System.nanoTime();
            int count = setup.threadCount >= 4 ? 3 : repeat;
            PerfTestDriver.runPerfTest(count, x++, setup, pb);
            System.out.printf(" took %.1f seconds%n", (double)(System.nanoTime() - t1) / 1.0E9);
            FileReader reader = new FileReader(setup.temp);
            CharBuffer buffer = CharBuffer.allocate(262144);
            reader.read(buffer);
            reader.close();
            setup.temp.delete();
            buffer.flip();
            String raw = buffer.toString();
            System.out.print(raw);
            Stats stats = new Stats(raw);
            System.out.println(stats);
            System.out.println("-----");
            setup.stats = stats;
        }
        new File("perftest.log").delete();
    }

    private static void printRanking(Setup[] tests) {
        System.out.println();
        System.out.println("Ranking:");
        Arrays.sort(tests);
        for (int i = 0; i < tests.length; ++i) {
            Setup setup = tests[i];
            System.out.println(i + 1 + ". " + setup.description() + ": " + setup.stats);
        }
    }

    private static void runPerfTest(int repeat, int setupIndex, Setup config, ProcessBuilder pb) throws IOException, InterruptedException {
        for (int i = 0; i < repeat; ++i) {
            System.out.print(" (" + (i + 1) + '/' + repeat + ")...");
            Process process = pb.start();
            boolean[] stop = new boolean[]{false};
            PerfTestDriver.printProcessOutput(process, stop);
            process.waitFor();
            stop[0] = true;
            File gc = new File("gc" + setupIndex + '_' + i + config.log4jConfig + ".log");
            if (gc.exists()) {
                gc.delete();
            }
            new File("gc.log").renameTo(gc);
        }
    }

    private static Thread printProcessOutput(final Process process, final boolean[] stop) {
        Thread t = new Thread("OutputWriter"){

            @Override
            public void run() {
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    String line = null;
                    while (!stop[0] && (line = in.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        return t;
    }

    static enum Runner {
        Log4j12(RunLog4j1.class),
        Log4j2(RunLog4j2.class),
        Logback(RunLogback.class);

        private final Class<? extends IPerfTestRunner> implementationClass;

        private Runner(Class<? extends IPerfTestRunner> cls) {
            this.implementationClass = cls;
        }
    }

    static class Stats {
        int count;
        long average;
        long pct99;
        long pct99_99;
        double latencyRowCount;
        int throughputRowCount;
        private final long averageOpsPerSec;

        public Stats(String raw) {
            String[] lines = raw.split("[\\r\\n]+");
            long totalOps = 0L;
            for (String line : lines) {
                if (line.startsWith("avg")) {
                    this.latencyRowCount += 1.0;
                    String[] parts = line.split(" ");
                    int i = 0;
                    this.average += Long.parseLong(parts[i++].split("=")[1]);
                    this.pct99 += Long.parseLong(parts[i++].split("=")[1]);
                    this.pct99_99 += Long.parseLong(parts[i++].split("=")[1]);
                    this.count += Integers.parseInt((String)parts[i].split("=")[1]);
                    continue;
                }
                ++this.throughputRowCount;
                String number = line.substring(0, line.indexOf(32));
                long opsPerSec = Long.parseLong(number);
                totalOps += opsPerSec;
            }
            this.averageOpsPerSec = totalOps / (long)this.throughputRowCount;
        }

        public String toString() {
            String fmt = "throughput: %,d ops/sec. latency(ns): avg=%.1f 99%% < %.1f 99.99%% < %.1f (%d samples)";
            return String.format("throughput: %,d ops/sec. latency(ns): avg=%.1f 99%% < %.1f 99.99%% < %.1f (%d samples)", this.averageOpsPerSec, (double)this.average / this.latencyRowCount, (double)this.pct99 / this.latencyRowCount, (double)this.pct99_99 / this.latencyRowCount, this.count);
        }
    }

    static class Setup
    implements Comparable<Setup> {
        private final Class<?> klass;
        private final String log4jConfig;
        private final String name;
        private final String[] systemProperties;
        private final int threadCount;
        private final File temp;
        public Stats stats;
        private final WaitStrategy wait;
        private final Runner runner;

        public Setup(Class<?> klass, Runner runner, String name, String log4jConfig, int threadCount, WaitStrategy wait, String ... systemProperties) throws IOException {
            this.klass = klass;
            this.runner = runner;
            this.name = name;
            this.log4jConfig = log4jConfig;
            this.threadCount = threadCount;
            this.systemProperties = systemProperties;
            this.wait = wait;
            this.temp = File.createTempFile("log4jperformance", ".txt");
        }

        List<String> processArguments(String java) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(java);
            args.add("-server");
            args.add("-Xms1g");
            args.add("-Xmx1g");
            args.add("-Dlog4j.configuration=" + this.log4jConfig);
            args.add("-Dlog4j.configurationFile=" + this.log4jConfig);
            args.add("-Dlogback.configurationFile=" + this.log4jConfig);
            int ringBufferSize = this.getUserSpecifiedRingBufferSize();
            if (ringBufferSize >= 128) {
                args.add("-DAsyncLoggerConfig.RingBufferSize=" + ringBufferSize);
                args.add("-DAsyncLogger.RingBufferSize=" + ringBufferSize);
            }
            args.add("-DAsyncLoggerConfig.WaitStrategy=" + (Object)((Object)this.wait));
            args.add("-DAsyncLogger.WaitStrategy=" + (Object)((Object)this.wait));
            if (this.systemProperties != null) {
                Collections.addAll(args, this.systemProperties);
            }
            args.add("-cp");
            args.add(System.getProperty("java.class.path"));
            args.add(this.klass.getName());
            args.add(this.runner.implementationClass.getName());
            args.add(this.name);
            args.add(this.temp.getAbsolutePath());
            args.add(String.valueOf(this.threadCount));
            return args;
        }

        private int getUserSpecifiedRingBufferSize() {
            try {
                return Integers.parseInt((String)System.getProperty("RingBufferSize", "-1"));
            }
            catch (Exception ignored) {
                return -1;
            }
        }

        ProcessBuilder latencyTest(String java) {
            return new ProcessBuilder(this.processArguments(java));
        }

        ProcessBuilder throughputTest(String java) {
            List<String> args = this.processArguments(java);
            args.add("-throughput");
            return new ProcessBuilder(args);
        }

        @Override
        public int compareTo(Setup other) {
            return Long.signum(other.stats.averageOpsPerSec - this.stats.averageOpsPerSec);
        }

        public String description() {
            String detail = this.klass.getSimpleName();
            if (PerfTest.class == this.klass) {
                detail = "single thread";
            } else if (MultiThreadPerfTest.class == this.klass) {
                detail = this.threadCount + " threads";
            }
            String target = this.runner.name();
            return target + ": " + this.name + " (" + detail + ')';
        }
    }

    static enum WaitStrategy {
        Sleep,
        Yield,
        Block;


        public static WaitStrategy get() {
            return WaitStrategy.valueOf(System.getProperty("WaitStrategy", PerfTestDriver.DEFAULT_WAIT_STRATEGY));
        }
    }
}

