/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RoutingAppender3350Test {
    private static final String CONFIG = "log4j-routing3350.xml";
    private static final String LOG_FILE = "target/tmp/test.log";
    private final LoggerContextRule loggerContextRule = new LoggerContextRule("log4j-routing3350.xml");
    @Rule
    public RuleChain rules = this.loggerContextRule.withCleanFilesRule("target/tmp/test.log");

    @After
    public void tearDown() throws Exception {
        this.loggerContextRule.getLoggerContext().stop();
    }

    @Test
    public void routingTest() throws IOException {
        String expected = "expectedValue";
        StringMapMessage message = (StringMapMessage)new StringMapMessage().with("data", expected);
        ExtendedLogger logger = this.loggerContextRule.getLoggerContext().getLogger(this.getClass());
        logger.error((Message)message);
        File file = new File(LOG_FILE);
        try (FileInputStream inputStream = new FileInputStream(file);
             InputStreamReader streamReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(streamReader);){
            String actual = reader.readLine();
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }
}

