/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import org.apache.logging.log4j.core.appender.rolling.action.CountingCondition;
import org.apache.logging.log4j.core.appender.rolling.action.IfAccumulatedFileCount;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IfAccumulatedFileCountTest {
    @Test
    public void testGetThresholdCount() {
        Assertions.assertEquals((int)123, (int)IfAccumulatedFileCount.createFileCountCondition((int)123, (PathCondition[])new PathCondition[0]).getThresholdCount());
        Assertions.assertEquals((int)456, (int)IfAccumulatedFileCount.createFileCountCondition((int)456, (PathCondition[])new PathCondition[0]).getThresholdCount());
    }

    @Test
    public void testAccept() {
        int[] counts;
        for (int count : counts = new int[]{3, 5, 9}) {
            IfAccumulatedFileCount condition = IfAccumulatedFileCount.createFileCountCondition((int)count, (PathCondition[])new PathCondition[0]);
            for (int i = 0; i < count; ++i) {
                Assertions.assertFalse((boolean)condition.accept(null, null, null));
            }
            Assertions.assertTrue((boolean)condition.accept(null, null, null));
            Assertions.assertTrue((boolean)condition.accept(null, null, null));
        }
    }

    @Test
    public void testAcceptCallsNestedConditionsOnlyIfPathAccepted() {
        CountingCondition counter = new CountingCondition(true);
        IfAccumulatedFileCount condition = IfAccumulatedFileCount.createFileCountCondition((int)3, (PathCondition[])new PathCondition[]{counter});
        for (int i = 1; i < 10; ++i) {
            if (i <= 3) {
                Assertions.assertFalse((boolean)condition.accept(null, null, null), (String)("i=" + i));
                Assertions.assertEquals((int)0, (int)counter.getAcceptCount());
                continue;
            }
            Assertions.assertTrue((boolean)condition.accept(null, null, null));
            Assertions.assertEquals((int)(i - 3), (int)counter.getAcceptCount());
        }
    }

    @Test
    public void testBeforeTreeWalk() {
        CountingCondition counter = new CountingCondition(true);
        IfAccumulatedFileCount filter = IfAccumulatedFileCount.createFileCountCondition((int)30, (PathCondition[])new PathCondition[]{counter, counter, counter});
        filter.beforeFileTreeWalk();
        Assertions.assertEquals((int)3, (int)counter.getBeforeFileTreeWalkCount());
    }
}

