/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderDirectWrite1906Test {
    private static final String CONFIG = "log4j-rolling-direct-1906.xml";
    private static final String DIR = "target/rolling-direct-1906";
    public static LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-direct-1906.xml");
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/rolling-direct-1906");
    private Logger logger;

    @BeforeClass
    public static void setupClass() throws Exception {
        StatusLogger.getLogger().registerListener((StatusListener)new NoopStatusListener());
    }

    @Before
    public void setUp() throws Exception {
        this.logger = loggerContextRule.getLogger(RollingAppenderDirectWrite1906Test.class.getName());
    }

    @Test
    public void testAppender() throws Exception {
        int count = 100;
        for (int i = 0; i < 100; ++i) {
            this.logger.debug("This is test message number " + i);
            Thread.sleep(50L);
        }
        Thread.sleep(50L);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (dir.exists() && dir.listFiles().length > 0 ? 1 : 0) != 0);
        File[] files = dir.listFiles();
        Assert.assertNotNull((Object)files);
        Assert.assertThat((Object)files, (Matcher)Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".log"))))));
        int found = 0;
        for (File file : files) {
            String line;
            String actual = file.getName();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                Assert.assertNotNull((String)("No log event in file " + actual), (Object)line);
                String[] parts = line.split(" ");
                String expected = "rollingfile." + parts[0] + ".log";
                Assert.assertEquals((String)this.logFileNameError(expected, actual), (Object)expected, (Object)actual);
                ++found;
            }
            reader.close();
        }
        Assert.assertEquals((String)("Incorrect number of events read. Expected 100, Actual " + found), (long)100L, (long)found);
    }

    private String logFileNameError(String expected, String actual) {
        List statusData = StatusLogger.getLogger().getStatusData();
        StringBuilder sb = new StringBuilder();
        for (StatusData statusItem : statusData) {
            sb.append(statusItem.getFormattedStatus());
            sb.append("\n");
        }
        sb.append("Incorrect file name. Expected: ").append(expected).append(" Actual: ").append(actual);
        return sb.toString();
    }

    private static class NoopStatusListener
    implements StatusListener {
        private NoopStatusListener() {
        }

        public void log(StatusData data) {
        }

        public Level getStatusLevel() {
            return Level.TRACE;
        }

        public void close() throws IOException {
        }
    }
}

