/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderCronEvery2DirectTest {
    private static final String CONFIG = "log4j-rolling-cron-every2-direct.xml";
    private static final String DIR = "target/rolling-cron-every2Direct";
    private static final int LOOP_COUNT = 100;
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-cron-every2-direct.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling-cron-every2Direct");

    @Test
    public void testAppender() throws Exception {
        Logger logger = this.loggerContextRule.getLogger();
        long end = System.currentTimeMillis() + 5000L;
        SecureRandom rand = new SecureRandom();
        ((Random)rand).setSeed(end);
        int count = 1;
        do {
            logger.debug("Log Message {}", (Object)count++);
            Thread.sleep(10 * rand.nextInt(100));
        } while (System.currentTimeMillis() < end);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (dir.exists() && dir.listFiles().length > 0 ? 1 : 0) != 0);
        int MAX_TRIES = 20;
        Matcher hasGzippedFile = Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".gz")))));
        boolean succeeded = false;
        for (int i = 0; i < 20; ++i) {
            File[] files = dir.listFiles();
            if (hasGzippedFile.matches((Object)files)) {
                succeeded = true;
                break;
            }
            logger.debug("Sleeping #" + i);
            Thread.sleep(100L);
        }
        if (!succeeded) {
            File[] files;
            for (File dirFile : files = dir.listFiles()) {
                logger.error("Found file: " + dirFile.getPath());
            }
            Assert.fail((String)"No compressed files found");
        }
    }
}

