/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.junit.CleanUpDirectories;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.util.Unbox;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

@CleanUpDirectories(value={"target/permissions1"})
public class FileAppenderPermissionsTest {
    static final String DIR = "target/permissions1";

    @BeforeAll
    public static void beforeClass() {
        System.setProperty("log4j2.debug", "true");
        Assumptions.assumeTrue((boolean)FileUtils.isFilePosixAttributeViewSupported());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @CsvSource(value={"rwxrwxrwx,true,2", "rw-r--r--,false,3", "rw-------,true,4", "rw-rw----,false,5"})
    public void testFilePermissionsAPI(String filePermissions, boolean createOnDemand, int fileIndex) throws Exception {
        File file = new File(DIR, "AppenderTest-" + fileIndex + ".log");
        Path path = file.toPath();
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d [%t] %p %c - %m%n").build();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(file.getAbsolutePath()).setName("test")).withImmediateFlush(false)).setIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(1)).setLayout((Layout)layout)).withCreateOnDemand(createOnDemand).withFilePermissions(filePermissions).build();
        try {
            long curLen;
            appender.start();
            Assertions.assertTrue((boolean)appender.isStarted(), (String)"Appender did not start");
            Assertions.assertNotEquals((Object)createOnDemand, (Object)Files.exists(path, new LinkOption[0]));
            long prevLen = curLen = file.length();
            Assertions.assertEquals((long)curLen, (long)0L, (String)("File length: " + curLen));
            for (int i = 0; i < 100; ++i) {
                Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("TestLogger").setLoggerFqcn(FileAppenderPermissionsTest.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Test")).setThreadName(this.getClass().getSimpleName()).setTimeMillis(System.currentTimeMillis()).build();
                appender.append((LogEvent)event);
                curLen = file.length();
                Assertions.assertTrue((curLen > prevLen ? 1 : 0) != 0, (String)("File length: " + curLen));
                Thread.sleep(25L);
                prevLen = curLen;
            }
            Assertions.assertEquals((Object)filePermissions, (Object)PosixFilePermissions.toString(Files.getPosixFilePermissions(path, new LinkOption[0])));
        }
        finally {
            appender.stop();
        }
        Assertions.assertFalse((boolean)appender.isStarted(), (String)"Appender did not stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @CsvSource(value={"rwxrwxrwx,2", "rw-r--r--,3", "rw-------,4", "rw-rw----,5"})
    public void testFileUserGroupAPI(String filePermissions, int fileIndex) throws Exception {
        File file = new File(DIR, "AppenderTest-" + (1000 + fileIndex) + ".log");
        Path path = file.toPath();
        String user = FileAppenderPermissionsTest.findAUser();
        Assertions.assertNotNull((Object)user);
        String group = FileAppenderPermissionsTest.findAGroup(user);
        Assertions.assertNotNull((Object)group);
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d [%t] %p %c - %m%n").build();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(file.getAbsolutePath()).setName("test")).withImmediateFlush(true)).setIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(1)).setLayout((Layout)layout)).withFilePermissions(filePermissions).withFileOwner(user).withFileGroup(group).build();
        try {
            long curLen;
            appender.start();
            Assertions.assertTrue((boolean)appender.isStarted(), (String)"Appender did not start");
            long prevLen = curLen = file.length();
            Assertions.assertEquals((long)curLen, (long)0L, (String)(file + " File length: " + curLen));
            for (int i = 0; i < 100; ++i) {
                Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("TestLogger").setLoggerFqcn(FileAppenderPermissionsTest.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Test")).setThreadName(this.getClass().getSimpleName()).setTimeMillis(System.currentTimeMillis()).build();
                appender.append((LogEvent)event);
                curLen = file.length();
                Assertions.assertTrue((curLen > prevLen ? 1 : 0) != 0, (String)("File length: " + curLen));
                Thread.sleep(25L);
                prevLen = curLen;
            }
            Assertions.assertEquals((Object)filePermissions, (Object)PosixFilePermissions.toString(Files.getPosixFilePermissions(path, new LinkOption[0])));
            Assertions.assertEquals((Object)user, (Object)Files.getOwner(path, new LinkOption[0]).getName());
            Assertions.assertEquals((Object)group, (Object)Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]).group().getName());
        }
        finally {
            appender.stop();
        }
        Assertions.assertFalse((boolean)appender.isStarted(), (String)"Appender did not stop");
    }

    @Test
    @LoggerContextSource(value="log4j-posix.xml", timeout=10L)
    void testFilePermissions(LoggerContext context) throws IOException {
        ExtendedLogger logger = context.getLogger(this.getClass());
        for (int i = 0; i < 1000; ++i) {
            logger.debug("This is test message number {}", (Object)Unbox.box((int)i));
        }
        String permissions = PosixFilePermissions.toString(Files.getPosixFilePermissions(Paths.get("target/permissions1/AppenderTest-1.log", new String[0]), new LinkOption[0]));
        Assertions.assertEquals((Object)"rw-------", (Object)permissions);
    }

    public static String findAGroup(String user) throws IOException {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return "staff";
        }
        try (Stream<String> lines = Files.lines(Paths.get("/etc/group", new String[0]));){
            String string = lines.filter(group -> !group.startsWith(user) && group.contains(user)).map(group -> group.substring(0, group.indexOf(58))).findAny().orElse(user);
            return string;
        }
    }

    private static String findAUser() throws IOException {
        return System.getProperty("user.name");
    }
}

