/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.nio.charset.Charset;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsoleAppenderBuilderTest {
    @Test
    public void testDefaultImmediateFlush() {
        Assertions.assertTrue((boolean)ConsoleAppender.newBuilder().isImmediateFlush());
    }

    @Test
    public void testDefaultLayoutDefaultCharset() {
        ConsoleAppender appender = ((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("test")).build();
        PatternLayout layout = (PatternLayout)appender.getLayout();
        String charsetName = System.getProperty("sun.stdout.encoding");
        String expectedName = charsetName != null ? charsetName : Charset.defaultCharset().name();
        Assertions.assertEquals((Object)expectedName, (Object)layout.getCharset().name());
    }

    @Test
    public void testSetNullErrorHandlerIsNotAllowed() {
        ConsoleAppender appender = ((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("test")).build();
        ErrorHandler handler = appender.getHandler();
        Assertions.assertNotNull((Object)handler);
        appender.setHandler(null);
        Assertions.assertSame((Object)handler, (Object)appender.getHandler());
    }
}

