/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-customLevels.xml")
public class CustomLevelsTest {
    private final ListAppender listAppender;
    private final Level diagLevel = Level.getLevel((String)"DIAG");
    private final Level noticeLevel = Level.getLevel((String)"NOTICE");
    private final Level verboseLevel = Level.getLevel((String)"VERBOSE");
    private final Logger logger;

    public CustomLevelsTest(LoggerContext context, @Named(value="List1") ListAppender appender) {
        this.listAppender = appender.clear();
        this.logger = context.getLogger(this.getClass().getName());
    }

    @Test
    public void testCustomLevelInts() {
        Assertions.assertEquals((int)350, (int)this.diagLevel.intLevel());
        Assertions.assertEquals((int)450, (int)this.noticeLevel.intLevel());
        Assertions.assertEquals((int)550, (int)this.verboseLevel.intLevel());
    }

    @Test
    public void testCustomLevelPresence() {
        Assertions.assertNotNull((Object)this.diagLevel);
        Assertions.assertNotNull((Object)this.noticeLevel);
        Assertions.assertNotNull((Object)this.verboseLevel);
    }

    @Test
    public void testLog() {
        MatcherAssert.assertThat(this.listAppender.getEvents(), (Matcher)Matchers.hasSize((int)0));
        this.logger.debug("Hello, {}", (Object)"World");
        MatcherAssert.assertThat(this.listAppender.getEvents(), (Matcher)Matchers.hasSize((int)1));
        this.logger.log(this.diagLevel, "Hello DIAG");
        MatcherAssert.assertThat(this.listAppender.getEvents(), (Matcher)Matchers.hasSize((int)2));
        Assertions.assertEquals((Object)this.listAppender.getEvents().get(1).getLevel(), (Object)this.diagLevel);
    }
}

