/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.time;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.core.time.internal.FixedPreciseClock;
import org.apache.logging.log4j.core.util.Clock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MutableInstantTest {
    MutableInstantTest() {
    }

    @Test
    void testGetEpochSecond() {
        MutableInstant instant = new MutableInstant();
        Assertions.assertEquals((long)0L, (long)instant.getEpochSecond(), (String)"initial");
        instant.initFromEpochSecond(123L, 456);
        Assertions.assertEquals((long)123L, (long)instant.getEpochSecond(), (String)"returns directly set value");
        instant.initFromEpochMilli(123456L, 789012);
        Assertions.assertEquals((long)123L, (long)instant.getEpochSecond(), (String)"returns converted value when initialized from milllis");
        MutableInstant other = new MutableInstant();
        other.initFromEpochSecond(788L, 456);
        instant.initFrom((Instant)other);
        Assertions.assertEquals((long)788L, (long)instant.getEpochSecond(), (String)"returns ref value when initialized from instant");
    }

    @Test
    void testGetNanoOfSecond() {
        MutableInstant instant = new MutableInstant();
        Assertions.assertEquals((int)0, (int)instant.getNanoOfSecond(), (String)"initial");
        instant.initFromEpochSecond(123L, 456);
        Assertions.assertEquals((int)456, (int)instant.getNanoOfSecond(), (String)"returns directly set value");
        instant.initFromEpochMilli(123456L, 789012);
        Assertions.assertEquals((int)456789012, (int)instant.getNanoOfSecond(), (String)"returns converted value when initialized from milllis");
        MutableInstant other = new MutableInstant();
        other.initFromEpochSecond(788L, 456);
        instant.initFrom((Instant)other);
        Assertions.assertEquals((int)456, (int)instant.getNanoOfSecond(), (String)"returns ref value when initialized from instant");
    }

    @Test
    void testGetEpochMillisecond() {
        MutableInstant instant = new MutableInstant();
        Assertions.assertEquals((long)0L, (long)instant.getEpochMillisecond(), (String)"initial");
        instant.initFromEpochMilli(123L, 456);
        Assertions.assertEquals((long)123L, (long)instant.getEpochMillisecond(), (String)"returns directly set value");
        instant.initFromEpochSecond(123L, 456789012);
        Assertions.assertEquals((long)123456L, (long)instant.getEpochMillisecond(), (String)"returns converted value when initialized from seconds");
        MutableInstant other = new MutableInstant();
        other.initFromEpochMilli(788L, 456);
        instant.initFrom((Instant)other);
        Assertions.assertEquals((long)788L, (long)instant.getEpochMillisecond(), (String)"returns ref value when initialized from instant");
    }

    @Test
    void getGetNanoOfMillisecond() {
        MutableInstant instant = new MutableInstant();
        Assertions.assertEquals((int)0, (int)instant.getNanoOfMillisecond(), (String)"initial");
        instant.initFromEpochMilli(123L, 456);
        Assertions.assertEquals((int)456, (int)instant.getNanoOfMillisecond(), (String)"returns directly set value");
        instant.initFromEpochSecond(123L, 456789012);
        Assertions.assertEquals((int)789012, (int)instant.getNanoOfMillisecond(), (String)"returns converted value when initialized from milllis");
        MutableInstant other = new MutableInstant();
        other.initFromEpochMilli(788L, 456);
        instant.initFrom((Instant)other);
        Assertions.assertEquals((int)456, (int)instant.getNanoOfMillisecond(), (String)"returns ref value when initialized from instant");
    }

    @Test
    void testInitFromInstantRejectsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new MutableInstant().initFrom((Instant)null));
    }

    @Test
    void testInitFromInstantCopiesValues() {
        MutableInstant other = new MutableInstant();
        other.initFromEpochSecond(788L, 456);
        Assertions.assertEquals((long)788L, (long)other.getEpochSecond(), (String)"epochSec");
        Assertions.assertEquals((int)456, (int)other.getNanoOfSecond(), (String)"NanosOfSec");
        MutableInstant instant = new MutableInstant();
        instant.initFrom((Instant)other);
        Assertions.assertEquals((long)788L, (long)instant.getEpochSecond(), (String)"epochSec");
        Assertions.assertEquals((int)456, (int)instant.getNanoOfSecond(), (String)"NanoOfSec");
    }

    @Test
    void testInitFromEpochMillis() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochMilli(123456L, 789012);
        Assertions.assertEquals((long)123L, (long)instant.getEpochSecond(), (String)"epochSec");
        Assertions.assertEquals((int)456789012, (int)instant.getNanoOfSecond(), (String)"NanoOfSec");
        Assertions.assertEquals((long)123456L, (long)instant.getEpochMillisecond(), (String)"epochMilli");
        Assertions.assertEquals((int)789012, (int)instant.getNanoOfMillisecond(), (String)"NanoOfMilli");
    }

    @Test
    void testInitFromEpochMillisRejectsNegativeNanoOfMilli() {
        MutableInstant instant = new MutableInstant();
        Assertions.assertThrows(IllegalArgumentException.class, () -> instant.initFromEpochMilli(123456L, -1));
    }

    @Test
    void testInitFromEpochMillisRejectsTooLargeNanoOfMilli() {
        MutableInstant instant = new MutableInstant();
        Assertions.assertThrows(IllegalArgumentException.class, () -> instant.initFromEpochMilli(123456L, 1000000));
    }

    @Test
    void testInitFromEpochMillisAcceptsTooMaxNanoOfMilli() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochMilli(123456L, 999999);
        Assertions.assertEquals((int)999999, (int)instant.getNanoOfMillisecond(), (String)"NanoOfMilli");
    }

    @Test
    void testInitFromEpochSecond() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(123L, 456789012);
        Assertions.assertEquals((long)123L, (long)instant.getEpochSecond(), (String)"epochSec");
        Assertions.assertEquals((int)456789012, (int)instant.getNanoOfSecond(), (String)"NanoOfSec");
        Assertions.assertEquals((long)123456L, (long)instant.getEpochMillisecond(), (String)"epochMilli");
        Assertions.assertEquals((int)789012, (int)instant.getNanoOfMillisecond(), (String)"NanoOfMilli");
    }

    @Test
    void testInitFromEpochSecondRejectsNegativeNanoOfMilli() {
        MutableInstant instant = new MutableInstant();
        Assertions.assertThrows(IllegalArgumentException.class, () -> instant.initFromEpochSecond(123456L, -1));
    }

    @Test
    void testInitFromEpochSecondRejectsTooLargeNanoOfMilli() {
        MutableInstant instant = new MutableInstant();
        Assertions.assertThrows(IllegalArgumentException.class, () -> instant.initFromEpochSecond(123456L, 1000000000));
    }

    @Test
    void testInitFromEpochSecondAcceptsTooMaxNanoOfMilli() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(123456L, 999999999);
        Assertions.assertEquals((int)999999999, (int)instant.getNanoOfSecond(), (String)"NanoOfSec");
    }

    @Test
    void testInstantToMillisAndNanos() {
        long[] values = new long[2];
        MutableInstant.instantToMillisAndNanos((long)123456L, (int)999999999, (long[])values);
        Assertions.assertEquals((long)123456999L, (long)values[0]);
        Assertions.assertEquals((long)999999L, (long)values[1]);
    }

    @Test
    void testInitFromClock() {
        MutableInstant instant = new MutableInstant();
        FixedPreciseClock clock = new FixedPreciseClock(123456L, 789012);
        instant.initFrom((Clock)clock);
        Assertions.assertEquals((long)123456L, (long)instant.getEpochMillisecond());
        Assertions.assertEquals((int)789012, (int)instant.getNanoOfMillisecond());
        Assertions.assertEquals((long)123L, (long)instant.getEpochSecond());
        Assertions.assertEquals((int)456789012, (int)instant.getNanoOfSecond());
    }

    @Test
    void testEquals() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(123L, 456789012);
        MutableInstant instant2 = new MutableInstant();
        instant2.initFromEpochMilli(123456L, 789012);
        Assertions.assertEquals((Object)instant, (Object)instant2);
    }

    @Test
    void testHashCode() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(123L, 456789012);
        MutableInstant instant2 = new MutableInstant();
        instant2.initFromEpochMilli(123456L, 789012);
        Assertions.assertEquals((int)instant.hashCode(), (int)instant2.hashCode());
        instant2.initFromEpochMilli(123456L, 789013);
        Assertions.assertNotEquals((int)instant.hashCode(), (int)instant2.hashCode());
    }

    @Test
    void testToString() {
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(123L, 456789012);
        Assertions.assertEquals((Object)"MutableInstant[epochSecond=123, nano=456789012]", (Object)instant.toString());
        instant.initFromEpochMilli(123456L, 789012);
        Assertions.assertEquals((Object)"MutableInstant[epochSecond=123, nano=456789012]", (Object)instant.toString());
    }

    @Test
    void testTemporalAccessor() {
        java.time.Instant javaInstant = java.time.Instant.parse("2020-05-10T22:09:04.123456789Z");
        MutableInstant log4jInstant = new MutableInstant();
        log4jInstant.initFromEpochSecond(javaInstant.getEpochSecond(), javaInstant.getNano());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'").withZone(ZoneId.of("UTC"));
        Assertions.assertEquals((Object)formatter.format(javaInstant), (Object)formatter.format((TemporalAccessor)log4jInstant));
    }
}

