/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.selector;

import java.lang.reflect.Field;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.selector.TestClassLoader;
import org.apache.logging.log4j.core.util.ReflectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClassLoaderContextSelectorTest {
    private static final String PKG = ClassLoaderContextSelectorTest.class.getPackage().getName();
    private ClassLoader loader1;
    private ClassLoader loader2;
    private ClassLoader loader3;

    @BeforeEach
    public void setUp() throws Exception {
        this.loader1 = new TestClassLoader();
        this.loader2 = new TestClassLoader();
        this.loader3 = new TestClassLoader();
        Assertions.assertNotSame((Object)this.loader1, (Object)this.loader2);
        Assertions.assertNotSame((Object)this.loader1, (Object)this.loader3);
        Assertions.assertNotSame((Object)this.loader2, (Object)this.loader3);
    }

    @Test
    public void testMultipleClassLoaders() throws Exception {
        Class<?> logging1 = this.loader1.loadClass(PKG + ".a.Logging1");
        Field field1 = logging1.getDeclaredField("logger");
        Logger logger1 = (Logger)ReflectionUtil.getStaticFieldValue((Field)field1);
        Assertions.assertNotNull((Object)logger1);
        Class<?> logging2 = this.loader2.loadClass(PKG + ".b.Logging2");
        Field field2 = logging2.getDeclaredField("logger");
        Logger logger2 = (Logger)ReflectionUtil.getStaticFieldValue((Field)field2);
        Assertions.assertNotNull((Object)logger2);
        Class<?> logging3 = this.loader3.loadClass(PKG + ".c.Logging3");
        Field field3 = logging3.getDeclaredField("logger");
        Logger logger3 = (Logger)ReflectionUtil.getStaticFieldValue((Field)field3);
        Assertions.assertNotNull((Object)logger3);
        Assertions.assertNotSame((Object)logger1.getContext(), (Object)logger2.getContext());
        Assertions.assertNotSame((Object)logger1.getContext(), (Object)logger3.getContext());
        Assertions.assertNotSame((Object)logger2.getContext(), (Object)logger3.getContext());
    }
}

