/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.selector;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.BasicContextSelector;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public final class BasicContextSelectorTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("Log4jContextSelector", BasicContextSelector.class.getName());
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("Log4jContextSelector");
    }

    @Test
    public void testLogManagerShutdown() {
        LoggerContext context = (LoggerContext)LogManager.getContext();
        Assert.assertEquals((Object)LifeCycle.State.STARTED, (Object)context.getState());
        LogManager.shutdown();
        Assert.assertEquals((Object)LifeCycle.State.STOPPED, (Object)context.getState());
    }

    @Test
    public void testNotDependentOnClassLoader() {
        Assert.assertFalse((boolean)LogManager.getFactory().isClassLoaderDependent());
    }
}

