/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.builder;

import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigurationBuilderTest {
    private static final String INDENT = "  ";
    private static final String EOL = System.lineSeparator();
    private static final String expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Configuration name=\"config name\" status=\"ERROR\" packages=\"foo,bar\" shutdownTimeout=\"5000\">" + EOL + "  " + "<Properties>" + EOL + "  " + "  " + "<Property name=\"MyKey\">MyValue</Property>" + EOL + "  " + "</Properties>" + EOL + "  " + "<Scripts>" + EOL + "  " + "  " + "<ScriptFile name=\"target/test-classes/scripts/filter.groovy\" path=\"target/test-classes/scripts/filter.groovy\" isWatched=\"true\"/>" + EOL + "  " + "</Scripts>" + EOL + "  " + "<CustomLevels>" + EOL + "  " + "  " + "<CustomLevel name=\"Panic\" intLevel=\"17\"/>" + EOL + "  " + "</CustomLevels>" + EOL + "  " + "<ThresholdFilter onMatch=\"ACCEPT\" onMismatch=\"NEUTRAL\" level=\"DEBUG\"/>" + EOL + "  " + "<Appenders>" + EOL + "  " + "  " + "<CONSOLE name=\"Stdout\" target=\"SYSTEM_OUT\">" + EOL + "  " + "  " + "  " + "<PatternLayout pattern=\"%d [%t] %-5level: %msg%n%throwable\"/>" + EOL + "  " + "  " + "  " + "<MarkerFilter onMatch=\"DENY\" onMismatch=\"NEUTRAL\" marker=\"FLOW\"/>" + EOL + "  " + "  " + "</CONSOLE>" + EOL + "  " + "  " + "<Kafka name=\"Kafka\" topic=\"my-topic\">" + EOL + "  " + "  " + "  " + "<Property name=\"bootstrap.servers\">localhost:9092</Property>" + EOL + "  " + "  " + "  " + "<GelfLayout host=\"my-host\">" + EOL + "  " + "  " + "  " + "  " + "<KeyValuePair key=\"extraField\" value=\"extraValue\"/>" + EOL + "  " + "  " + "  " + "</GelfLayout>" + EOL + "  " + "  " + "</Kafka>" + EOL + "  " + "</Appenders>" + EOL + "  " + "<Loggers>" + EOL + "  " + "  " + "<Logger name=\"org.apache.logging.log4j\" level=\"DEBUG\" includeLocation=\"true\" additivity=\"false\">" + EOL + "  " + "  " + "  " + "<AppenderRef ref=\"Stdout\"/>" + EOL + "  " + "  " + "</Logger>" + EOL + "  " + "  " + "<Logger name=\"org.apache.logging.log4j.core\">" + EOL + "  " + "  " + "  " + "<AppenderRef ref=\"Stdout\"/>" + EOL + "  " + "  " + "</Logger>" + EOL + "  " + "  " + "<Root level=\"ERROR\">" + EOL + "  " + "  " + "  " + "<AppenderRef ref=\"Stdout\"/>" + EOL + "  " + "  " + "</Root>" + EOL + "  " + "</Loggers>" + EOL + "</Configuration>" + EOL;

    private void addTestFixtures(String name, ConfigurationBuilder<BuiltConfiguration> builder) {
        builder.setConfigurationName(name);
        builder.setStatusLevel(Level.ERROR);
        builder.setShutdownTimeout(5000L, TimeUnit.MILLISECONDS);
        builder.add(builder.newScriptFile("target/test-classes/scripts/filter.groovy").addIsWatched(true));
        builder.add((FilterComponentBuilder)builder.newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.NEUTRAL).addAttribute("level", Level.DEBUG));
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d [%t] %-5level: %msg%n%throwable"));
        appenderBuilder.add((FilterComponentBuilder)builder.newFilter("MarkerFilter", Filter.Result.DENY, Filter.Result.NEUTRAL).addAttribute("marker", "FLOW"));
        builder.add(appenderBuilder);
        AppenderComponentBuilder appenderBuilder2 = (AppenderComponentBuilder)builder.newAppender("Kafka", "Kafka").addAttribute("topic", "my-topic");
        appenderBuilder2.addComponent((ComponentBuilder)builder.newProperty("bootstrap.servers", "localhost:9092"));
        appenderBuilder2.add((LayoutComponentBuilder)((LayoutComponentBuilder)builder.newLayout("GelfLayout").addAttribute("host", "my-host")).addComponent((ComponentBuilder)builder.newKeyValuePair("extraField", "extraValue")));
        builder.add(appenderBuilder2);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("org.apache.logging.log4j", Level.DEBUG, true).add(builder.newAppenderRef("Stdout"))).addAttribute("additivity", false));
        builder.add((LoggerComponentBuilder)builder.newLogger("org.apache.logging.log4j.core").add(builder.newAppenderRef("Stdout")));
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.ERROR).add(builder.newAppenderRef("Stdout")));
        builder.addProperty("MyKey", "MyValue");
        builder.add(builder.newCustomLevel("Panic", 17));
        builder.setPackages("foo,bar");
    }

    @Test
    public void testXmlConstructing() throws Exception {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        this.addTestFixtures("config name", (ConfigurationBuilder<BuiltConfiguration>)builder);
        String xmlConfiguration = builder.toXmlConfiguration();
        Assertions.assertEquals((Object)expectedXml, (Object)xmlConfiguration);
    }
}

