/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async.perftest;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.async.DefaultAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.async.perftest.IPerfTestRunner;
import org.apache.logging.log4j.core.async.perftest.IdleStrategy;
import org.apache.logging.log4j.core.async.perftest.NoOpIdleStrategy;
import org.apache.logging.log4j.core.async.perftest.YieldIdleStrategy;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.Loader;

public class ResponseTimeTest {
    private static final String LATENCY_MSG = new String(new char[64]);

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Please specify thread count, target throughput (msg/sec) and logger library (Log4j1, Log4j2, Logback, JUL)");
            return;
        }
        int threadCount = Integer.parseInt(args[0]);
        double loadMessagesPerSec = Double.parseDouble(args[1]);
        String loggerLib = args.length > 2 ? args[2] : "Log4j2";
        System.setProperty("log4j2.AsyncQueueFullPolicy", PrintingAsyncQueueFullPolicy.class.getName());
        System.setProperty("AsyncLogger.RingBufferSize", String.valueOf(262144));
        if (System.getProperty("AsyncLogger.WaitStrategy") == null) {
            System.setProperty("AsyncLogger.WaitStrategy", "Yield");
        }
        String wrapper = loggerLib.startsWith("Run") ? loggerLib : "Run" + loggerLib;
        String loggerWrapperClass = "org.apache.logging.log4j.core.async.perftest." + wrapper;
        IPerfTestRunner logger = (IPerfTestRunner)Loader.newCheckedInstanceOf((String)loggerWrapperClass, IPerfTestRunner.class);
        logger.log("Starting...");
        Thread.sleep(100L);
        int requiredProcessors = threadCount + 1 + 1;
        IdleStrategy idleStrategy = Runtime.getRuntime().availableProcessors() > requiredProcessors ? new NoOpIdleStrategy() : new YieldIdleStrategy();
        System.out.printf("%s: %d threads, load is %,f msg/sec, using %s%n", loggerLib, threadCount, loadMessagesPerSec, idleStrategy.getClass().getSimpleName());
        long WARMUP_DURATION_MILLIS = TimeUnit.MINUTES.toMillis(1L);
        ArrayList<Histogram> warmupServiceTmHistograms = new ArrayList<Histogram>(threadCount);
        ArrayList<Histogram> warmupResponseTmHistograms = new ArrayList<Histogram>(threadCount);
        int WARMUP_COUNT = 50000 / threadCount;
        ResponseTimeTest.runLatencyTest(logger, WARMUP_DURATION_MILLIS, WARMUP_COUNT, loadMessagesPerSec, idleStrategy, warmupServiceTmHistograms, warmupResponseTmHistograms, threadCount);
        System.out.println("-----------------Warmup done. load=" + loadMessagesPerSec);
        if (!Constants.ENABLE_DIRECT_ENCODERS || !Constants.ENABLE_THREADLOCALS) {
            // empty if block
        }
        System.out.println("-----------------Starting measured run. load=" + loadMessagesPerSec);
        long start = System.currentTimeMillis();
        ArrayList<Histogram> serviceTmHistograms = new ArrayList<Histogram>(threadCount);
        ArrayList<Histogram> responseTmHistograms = new ArrayList<Histogram>(threadCount);
        PrintingAsyncQueueFullPolicy.ringbufferFull.set(0L);
        long TEST_DURATION_MILLIS = TimeUnit.MINUTES.toMillis(4L);
        int COUNT = 1000000 / threadCount;
        ResponseTimeTest.runLatencyTest(logger, TEST_DURATION_MILLIS, COUNT, loadMessagesPerSec, idleStrategy, serviceTmHistograms, responseTmHistograms, threadCount);
        logger.shutdown();
        long end = System.currentTimeMillis();
        Histogram resultServiceTm = ResponseTimeTest.createResultHistogram(serviceTmHistograms, start, end);
        resultServiceTm.outputPercentileDistribution(System.out, Double.valueOf(1000.0));
        ResponseTimeTest.writeToFile("s", resultServiceTm, (int)(loadMessagesPerSec / 1000.0), 1000.0);
        Histogram resultResponseTm = ResponseTimeTest.createResultHistogram(responseTmHistograms, start, end);
        resultResponseTm.outputPercentileDistribution(System.out, Double.valueOf(1000.0));
        ResponseTimeTest.writeToFile("r", resultResponseTm, (int)(loadMessagesPerSec / 1000.0), 1000.0);
        System.out.printf("%n%s: %d threads, load %,f msg/sec, ringbuffer full=%d%n", loggerLib, threadCount, loadMessagesPerSec, PrintingAsyncQueueFullPolicy.ringbufferFull.get());
        System.out.println("Test duration: " + (double)(end - start) / 1000.0 + " seconds");
    }

    private static void writeToFile(String suffix, Histogram hist, int thousandMsgPerSec, double scale) throws IOException {
        try (PrintStream pout = new PrintStream(new FileOutputStream(thousandMsgPerSec + "k" + suffix));){
            hist.outputPercentileDistribution(pout, Double.valueOf(scale));
        }
    }

    private static Histogram createResultHistogram(List<Histogram> list, long start, long end) {
        Histogram result = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
        result.setStartTimeStamp(start);
        result.setEndTimeStamp(end);
        for (Histogram hist : list) {
            result.add((AbstractHistogram)hist);
        }
        return result;
    }

    public static void runLatencyTest(final IPerfTestRunner logger, final long durationMillis, final int samples, final double loadMessagesPerSec, final IdleStrategy idleStrategy, List<Histogram> serviceTmHistograms, List<Histogram> responseTmHistograms, int threadCount) throws InterruptedException {
        int i;
        Thread[] threads = new Thread[threadCount];
        final CountDownLatch LATCH = new CountDownLatch(threadCount);
        for (i = 0; i < threadCount; ++i) {
            final Histogram serviceTmHist = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
            final Histogram responseTmHist = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
            serviceTmHistograms.add(serviceTmHist);
            responseTmHistograms.add(responseTmHist);
            threads[i] = new Thread("latencytest-" + i){

                @Override
                public void run() {
                    LATCH.countDown();
                    try {
                        LATCH.await();
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                        return;
                    }
                    long endTimeMillis = System.currentTimeMillis() + durationMillis;
                    do {
                        Pacer pacer = new Pacer(loadMessagesPerSec, idleStrategy);
                        ResponseTimeTest.runLatencyTest(samples, logger, serviceTmHist, responseTmHist, pacer);
                    } while (System.currentTimeMillis() < endTimeMillis);
                }
            };
            threads[i].start();
        }
        for (i = 0; i < threadCount; ++i) {
            threads[i].join();
        }
    }

    private static void runLatencyTest(int samples, IPerfTestRunner logger, Histogram serviceTmHist, Histogram responseTmHist, Pacer pacer) {
        for (int i = 0; i < samples; ++i) {
            long expectedStartTimeNanos = pacer.expectedNextOperationNanoTime();
            pacer.acquire(1L);
            long actualStartTime = System.nanoTime();
            logger.log(LATENCY_MSG);
            long doneTime = System.nanoTime();
            serviceTmHist.recordValue(doneTime - actualStartTime);
            responseTmHist.recordValue(doneTime - expectedStartTimeNanos);
        }
    }

    static class Pacer {
        private long initialStartTime;
        private double throughputInUnitsPerNsec;
        private long unitsCompleted;
        private boolean caughtUp = true;
        private long catchUpStartTime;
        private long unitsCompletedAtCatchUpStart;
        private double catchUpThroughputInUnitsPerNsec;
        private double catchUpRateMultiple;
        private final IdleStrategy idleStrategy;

        public Pacer(double unitsPerSec, IdleStrategy idleStrategy) {
            this(unitsPerSec, 3.0, idleStrategy);
        }

        public Pacer(double unitsPerSec, double catchUpRateMultiple, IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            this.setThroughout(unitsPerSec);
            this.setCatchupRateMultiple(catchUpRateMultiple);
            this.initialStartTime = System.nanoTime();
        }

        public void setInitialStartTime(long initialStartTime) {
            this.initialStartTime = initialStartTime;
        }

        public void setThroughout(double unitsPerSec) {
            this.throughputInUnitsPerNsec = unitsPerSec / 1.0E9;
            this.catchUpThroughputInUnitsPerNsec = this.catchUpRateMultiple * this.throughputInUnitsPerNsec;
        }

        public void setCatchupRateMultiple(double multiple) {
            this.catchUpRateMultiple = multiple;
            this.catchUpThroughputInUnitsPerNsec = this.catchUpRateMultiple * this.throughputInUnitsPerNsec;
        }

        public long expectedNextOperationNanoTime() {
            return this.initialStartTime + (long)((double)this.unitsCompleted / this.throughputInUnitsPerNsec);
        }

        public long nsecToNextOperation() {
            long now = System.nanoTime();
            long nextStartTime = this.expectedNextOperationNanoTime();
            boolean sendNow = true;
            if (nextStartTime > now) {
                this.caughtUp = true;
                sendNow = false;
            } else {
                long unitsCompletedSinceCatchUpStart;
                if (this.caughtUp) {
                    this.caughtUp = false;
                    this.catchUpStartTime = now;
                    this.unitsCompletedAtCatchUpStart = this.unitsCompleted;
                }
                if ((nextStartTime = this.catchUpStartTime + (long)((double)(unitsCompletedSinceCatchUpStart = this.unitsCompleted - this.unitsCompletedAtCatchUpStart) / this.catchUpThroughputInUnitsPerNsec)) > now) {
                    sendNow = false;
                }
            }
            return sendNow ? 0L : nextStartTime - now;
        }

        public void acquire(long unitCount) {
            long nsecToNextOperation = this.nsecToNextOperation();
            if (nsecToNextOperation > 0L) {
                this.sleepNs(nsecToNextOperation);
            }
            this.unitsCompleted += unitCount;
        }

        private void sleepNs(long ns) {
            long now = System.nanoTime();
            long deadline = now + ns;
            while ((now = System.nanoTime()) < deadline) {
                this.idleStrategy.idle();
            }
        }
    }

    public static class PrintingAsyncQueueFullPolicy
    extends DefaultAsyncQueueFullPolicy {
        static AtomicLong ringbufferFull = new AtomicLong();

        public EventRoute getRoute(long backgroundThreadId, Level level) {
            ringbufferFull.incrementAndGet();
            System.out.print('!');
            return super.getRoute(backgroundThreadId, level);
        }
    }
}

