/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.AbstractRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescription;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class RollingFileManagerTest {
    @Test
    public void testCustomDirectFileRolloverStrategy() throws IOException {
        try (LoggerContext ctx = LoggerContext.getContext((boolean)false);){
            Configuration config = ctx.getConfiguration();
            File file = File.createTempFile("RollingFileAppenderAccessTest", ".tmp");
            file.deleteOnExit();
            class CustomDirectFileRolloverStrategy
            extends AbstractRolloverStrategy
            implements DirectFileRolloverStrategy {
                final File file;

                CustomDirectFileRolloverStrategy(File file, StrSubstitutor strSubstitutor) {
                    super(strSubstitutor);
                    this.file = file;
                }

                public String getCurrentFileName(RollingFileManager manager) {
                    return this.file.getAbsolutePath();
                }

                public void clearCurrentFileName() {
                }

                public RolloverDescription rollover(RollingFileManager manager) throws SecurityException {
                    return null;
                }
            }
            RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFilePattern("FilePattern").setName("RollingFileAppender")).setConfiguration(config)).withStrategy((RolloverStrategy)new CustomDirectFileRolloverStrategy(file, config.getConfigurationStrSubstitutor())).withPolicy((TriggeringPolicy)new SizeBasedTriggeringPolicy(100L)).build();
            Assert.assertNotNull((Object)appender);
            String testContent = "Test";
            try (RollingFileManager manager = (RollingFileManager)appender.getManager();){
                Assert.assertEquals((Object)file.getAbsolutePath(), (Object)manager.getFileName());
                manager.writeToDestination("Test".getBytes(StandardCharsets.US_ASCII), 0, "Test".length());
            }
            var8_10 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.US_ASCII);){
                Assert.assertEquals((Object)"Test", (Object)IOUtils.toString((Reader)reader));
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
        }
    }
}

