/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.SyslogAppender;
import org.apache.logging.log4j.core.layout.Rfc5424Layout;
import org.apache.logging.log4j.core.layout.SyslogLayout;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.net.Priority;
import org.apache.logging.log4j.core.net.mock.MockSyslogServer;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class SyslogAppenderTestBase {
    protected static final String line1 = "TestApp - Audit [Transfer@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"][RequestContext@18060 ipAddress=\"192.168.0.120\" loginId=\"JohnDoe\"] Transfer Complete";
    protected LoggerContext ctx = LoggerContext.getContext();
    protected static final int DEFAULT_TIMEOUT_IN_MS = 100;
    protected static final int PORTNUM = 8199;
    protected MockSyslogServer syslogServer;
    protected SyslogAppender appender;
    protected Logger root = this.ctx.getLogger("SyslogAppenderTest");
    protected List<String> sentMessages = new ArrayList<String>();
    protected boolean includeNewLine = true;

    @BeforeClass
    public static void setupClass() throws Exception {
        LoggerContext.getContext().reconfigure();
    }

    protected void sendAndCheckLegacyBsdMessages(List<String> messagesToSend) throws InterruptedException {
        for (String message : messagesToSend) {
            this.sendDebugLegacyBsdMessage(message);
        }
        this.checkTheNumberOfSentAndReceivedMessages();
        this.checkTheEqualityOfSentAndReceivedMessages(Level.DEBUG);
    }

    protected void sendAndCheckLegacyBsdMessage(String message) throws InterruptedException {
        this.sendDebugLegacyBsdMessage(message);
        this.checkTheNumberOfSentAndReceivedMessages();
        this.checkTheEqualityOfSentAndReceivedMessages(Level.DEBUG);
    }

    protected void sendDebugLegacyBsdMessage(String message) {
        this.sentMessages.add(message);
        this.root.debug(message);
    }

    protected void sendAndCheckStructuredMessages(int numberOfMessages) throws InterruptedException {
        for (int i = 0; i < numberOfMessages; ++i) {
            this.sendInfoStructuredMessage();
        }
        this.checkTheNumberOfSentAndReceivedMessages();
        this.checkTheEqualityOfSentAndReceivedMessages(Level.INFO);
    }

    protected void sendAndCheckStructuredMessage() throws InterruptedException {
        this.sendInfoStructuredMessage();
        this.checkTheNumberOfSentAndReceivedMessages();
        this.checkTheEqualityOfSentAndReceivedMessages(Level.INFO);
    }

    protected void sendInfoStructuredMessage() {
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        StructuredDataMessage msg = new StructuredDataMessage("Transfer@18060", "Transfer Complete", "Audit");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "123457");
        msg.put("Amount", "200.00");
        String str = msg.asString(null, null);
        this.sentMessages.add(str);
        this.root.info(MarkerManager.getMarker((String)"EVENT"), (Message)msg);
    }

    protected void checkTheNumberOfSentAndReceivedMessages() throws InterruptedException {
        Assert.assertEquals((String)"The number of received messages should be equal with the number of sent messages", (long)this.sentMessages.size(), (long)this.getReceivedMessages(100).size());
    }

    protected void checkTheEqualityOfSentAndReceivedMessages(Level expectedLevel) throws InterruptedException {
        List<String> receivedMessages = this.getReceivedMessages(100);
        Assert.assertNotNull((String)"No messages received", receivedMessages);
        for (int i = 0; i < receivedMessages.size(); ++i) {
            String receivedMessage = receivedMessages.get(i);
            String sentMessage = this.sentMessages.get(i);
            String suffix = this.includeNewLine ? "\n" : "";
            Assert.assertTrue((String)("Incorrect message received: " + receivedMessage), (receivedMessage.endsWith(sentMessage + suffix) || receivedMessage.contains(sentMessage) ? 1 : 0) != 0);
            int expectedPriority = Priority.getPriority((Facility)this.getExpectedFacility(), (Level)expectedLevel);
            Assert.assertTrue((String)("Expected facility " + expectedPriority + " in message " + receivedMessage), (boolean)receivedMessage.startsWith("<" + expectedPriority + ">"));
        }
    }

    protected void removeAppenders() {
        Map map = this.root.getAppenders();
        for (Map.Entry entry : map.entrySet()) {
            Appender app = (Appender)entry.getValue();
            this.root.removeAppender(app);
            app.stop();
        }
    }

    protected void initRootLogger(Appender appender) {
        this.root.addAppender(appender);
        this.root.setAdditive(false);
        this.root.setLevel(Level.DEBUG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getReceivedMessages(int timeOutInMs) throws InterruptedException {
        MockSyslogServer mockSyslogServer = this.syslogServer;
        synchronized (mockSyslogServer) {
            this.syslogServer.wait(timeOutInMs);
        }
        return this.syslogServer.getMessageList();
    }

    protected Facility getExpectedFacility() {
        return Facility.LOCAL0;
    }

    protected void validate(SyslogAppender syslogAppender) {
        Layout layout = syslogAppender.getLayout();
        if (layout instanceof SyslogLayout) {
            this.validate((SyslogLayout)layout);
        } else if (layout instanceof Rfc5424Layout) {
            this.validate((Rfc5424Layout)layout);
        } else {
            Assert.fail((String)("Unexpected layout: " + layout));
        }
    }

    protected void validate(Rfc5424Layout layout) {
        Assert.assertEquals((Object)this.getExpectedFacility(), (Object)layout.getFacility());
    }

    protected void validate(SyslogLayout layout) {
        Assert.assertEquals((Object)this.getExpectedFacility(), (Object)layout.getFacility());
    }
}

